/***************************************************************************
    screensavercontrol.h  -  Dient dem Zugriff auf den KDE-Screensaver
    --------------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.1 $
    CVS-ID    : $Id: screensavercontrol.h,v 1.1 2002/11/20 12:04:35 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SCREENSAVERCONTROL_H
#define SCREENSAVERCONTROL_H


// Qt include files:
#include <qbitarray.h>

// KDE include files:
#include <dcopclient.h>

// Forward-Deklarationen:
class QCString;


/**
 * <b>Klasse ScreenSaverControl</b>
 *
 * Erlaubt den Zugriff auf den KDE Bildschirmschoner. Dient z.B. dem Ein-
 * oder Ausschalten des Bildschirmschoners.
 *
 * @author Dirk Rosert <dirk@rosert.de>
 * $Revision: 1.1 $
 */
class ScreensaverControl
{
public:

  /** */
  ScreensaverControl();

  /** */
  ~ScreensaverControl();

  /** Gibt zurueck, ob der Bildschirmschoner eingeschaltet ist. */
  bool isEnabled();

  /**
   * Statische Methode zur Ermittlung, ob der KDE-Bildschirmschoner ein- oder
   * ausgeschaltet ist.
   * @return Status des KDE-Bildschirmschoners
   */
  static bool getSaverStatus();

  /**
   * Statische Methode zum Ein- oder Ausschalten des KDE-Bildschirmschoners.
   * @return Erfolg ?
   */
  static bool setEnabled(bool flag);


protected:

  /** Ermittelt die DCOP-Schnittstelle fuer den KDE-Bildschirmsch */
  bool getSaverDCOPIface();


private:

  /** */
  bool isValid;

  /** */
  bool dcopKDESaver;

  /** */
  QByteArray dcopData;

  /** */
  QCString dcopScreenSaverApp;

  /** */
  QCString dcopScreenSaverObj;

};


#endif // END SCREENSAVERCONTROL_H
