/***************************************************************************
    screensavercontrol.cpp  -  Dient dem Zugriff auf den KDE-Screensaver
    ----------------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.2 $
    CVS-ID    : $Id: screensavercontrol.cpp,v 1.2 2002/12/03 14:31:47 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Qt include files:
#include <qbitarray.h>
#include <qcstring.h>

// KDE include files:
#include <kapplication.h>
#include <kdebug.h>

// Application include files:
#include "screensavercontrol.h"


ScreensaverControl::ScreensaverControl()
{
  isValid = getSaverDCOPIface();
} // END ScreensaverControl()


ScreensaverControl::~ScreensaverControl()
{
} // END ~ScreensaverControl()


bool ScreensaverControl::getSaverDCOPIface()
{
  isValid =  kapp->dcopClient()->findObject("kdesktop",
                                            "KScreensaverIface",
                                            "enable(bool)",
                                            dcopData,
                                            dcopScreenSaverApp,
                                            dcopScreenSaverObj);

  return isValid;
} // END getSaverDCOPIface()


bool ScreensaverControl::isEnabled()
{
  bool enabled = false;
  QByteArray data, replyData;
  QCString replyType;

  if ( !kapp->dcopClient()->call(dcopScreenSaverApp, dcopScreenSaverObj,
                                 "isEnabled()", data, replyType, replyData) )
  {
    kdDebug() << "KTourPresenter(ScreensaverControl): Error in DCOP "
              << "communication to get status of KDE Screensaver !" << endl;
  }
  else
  {
    QDataStream reply(replyData, IO_ReadOnly);
    if ( replyType == "bool" )
      reply >> enabled;
    else
      kdDebug() << "KTourPresenter(ScreenaverControl): Error in DCOP "
                << "communication. Unexpected return type !" << endl;

  } // END if

  return enabled;

} // END isEnabled()


bool ScreensaverControl::getSaverStatus()
{
  bool DCOP_KDESaver;
  QByteArray DCOP_data;
  QCString DCOP_screenSaverApp, DCOP_screenSaverObj;

  DCOP_KDESaver = kapp->dcopClient()->findObject("kdesktop",
                                                 "KScreensaverIface",
                                                 "isEnabled()",
                                                 DCOP_data,
                                                 DCOP_screenSaverApp,
                                                 DCOP_screenSaverObj);

  if ( !DCOP_KDESaver )
    return false;

  bool enabled = false;

  QByteArray data, replyData;
  QCString replyType;

  if ( !kapp->dcopClient()->call(DCOP_screenSaverApp, DCOP_screenSaverObj,
                                 "isEnabled()", data, replyType, replyData) )
  {
    kdDebug() << "KTourPresnter(ScreensaverControl: Error in DCOP "
              << "communication to get status of of KDE Screendaver !" << endl;
  }
  else
  {
    QDataStream reply(replyData, IO_ReadOnly);
    if ( replyType == "bool" )
      reply >> enabled;

  } // END if
  
  return enabled;

} // END getSaverStatus()


bool ScreensaverControl::setEnabled(bool flag)
{
  bool DCOP_KDESaver;
  QByteArray DCOP_data;
  QCString DCOP_screenSaverApp, DCOP_screenSaverObj;

  DCOP_KDESaver = kapp->dcopClient()->findObject("kdesktop",
                                                 "KScreensaverIface",
                                                 "enable(bool)",
                                                 DCOP_data,
                                                 DCOP_screenSaverApp,
                                                 DCOP_screenSaverObj);

  QByteArray data;
  QDataStream arg(data, IO_WriteOnly);
  arg << flag;
  if ( !kapp->dcopClient()->send(DCOP_screenSaverApp, DCOP_screenSaverObj,
                                 "enable(bool)", data) )
  {
    kdDebug() << "KTourPresenter(SreensaverControl): Error in DCOP "
              << "communication. Unable to disable KDE Screensaver !" << endl;
    return false;
  } // END if

  return true;
} // END setEnabled()
