/***************************************************************************
    properties.cpp  -  Eigenschaften der Anwendung
    --------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.24 $
    CVS-ID    : $Id: properties.cpp,v 1.24 2002/11/10 11:35:47 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// STL include files:
#include <iostream>
#include <cstdlib>

// Qt include files:
#include <qstring.h>
#include <qsize.h>
#include <qcolor.h>

// Application include files:
#include "properties.h"


Properties::Properties()
{
  defaultValues();
} // END Properties()


// Attribute lesen:
// ----------------

bool Properties::startupLogo() const
{
  return m_startupLogo;
} // END startupLogo()

bool Properties::confirmExit() const
{
  return m_confirmExit;
} // END confirmExit()


bool Properties::screenSaverWarning() const
{
  return m_screenSaverWarning;
} // END screenSaverWarning()


QString Properties::base() const
{
  return m_base;
} // END base()


QString Properties::playFilename() const
{
  return m_playFilename;
} // END playFilename()


bool Properties::disableScreensaver() const
{
  return m_disableScreensaver;
} // END disableScreensaver()


QString Properties::defaultImageFilename() const
{
  return m_defaultImageFilename;
} // END defaultImageFilename()


QString Properties::soundFilename() const
{
  return m_soundFilename;
} // END soundFilename()


QString Properties::reportFilename() const
{
  return m_reportFilename;
} // END reportFilename()


bool Properties::autoLoad() const
{
  return m_autoLoad;
} // END autoLoad()


bool Properties::autoStart() const
{
  return m_autoStart;
} // END autoStart()


bool Properties::autoQuit() const
{
  return m_autoQuit;
} // END autoQuit()


bool Properties::extSlideChange() const
{
  return m_extSlideChange;
} // END extSlideChange()


QColor Properties::backgroundColor() const
{
  return m_backgroundColor;
} // END backgroundColor()


bool Properties::hideMouse() const
{
  return m_hideMouse;
} // END hideMouse()


int Properties::hideDelay() const
{
  return m_hideDelay;
} // END hideDelay()


unsigned int Properties::maxCache() const
{
  return m_maxCache;
} // END maxCache()


QString Properties::browserName() const
{
  return m_browserName;
} // END browserName()


unsigned int Properties::maxWidth() const
{
  return m_maxWidth;
} // END maxWidth()


unsigned int Properties::maxHeight() const
{
  return m_maxHeight;
} // END maxHeight()


// Attribute setzen:
// -----------------

void Properties::startupLogo(bool flag)
{
  m_startupLogo = flag;
} // END startupLogo()


void Properties::confirmExit(bool flag)
{
  m_confirmExit = flag;
} // END confirmExit()


void Properties::screenSaverWarning(bool flag)
{
  m_screenSaverWarning = flag;
} // END confirmExit()


void Properties::base(const QString& base)
{
  m_base = base;
  
  if ( m_base.isEmpty() )
    m_base = "/";

  // m_base muss mit '/' enden !
  if ( m_base.right(1) != "/" )
    m_base += "/";

} // END base()


void Properties::playFilename(const QString& filename)
{
  m_playFilename = filename;
} // END playFilename()


void Properties::fullscreen(bool fullscreen)
{
  m_fullscreen = fullscreen;
} // END fullscreen()


void Properties::disableScreensaver(bool flag)
{
  m_disableScreensaver = flag;
} // END disableScreensaver()


void Properties::defaultImageFilename(const QString& filename)
{
  m_defaultImageFilename = filename;
} // END defaultImageFilename()


void Properties::soundFilename(const QString& filename)
{
  m_soundFilename = filename;
} // END soundFilename()


void Properties::reportFilename(const QString& filename)
{
  m_reportFilename = filename;
} // END reportFilename()


void Properties::autoLoad(bool flag)
{
  m_autoLoad = flag;
} // END autoLoad()


void Properties::autoStart(bool flag)
{
  m_autoStart = flag;
} // END autoStart()


void Properties::autoQuit(bool flag)
{
  m_autoQuit = flag;
} // END autoQuit()


void Properties::extSlideChange(bool flag)
{
  m_extSlideChange = flag;
} // END extSlideChange()


void Properties::browserName(const QString& name)
{
  m_browserName = name;
} // END browserName()


void Properties::backgroundColor(const QColor& color)
{
  m_backgroundColor = color;
} // END backgroundColor()


void Properties::hideMouse(bool flag)
{
  m_hideMouse = flag;
} // END hideMouse()


void Properties::hideDelay(int delay)
{
  m_hideDelay = delay;
} // END hideDelay()


void Properties::gamma(int gamma)
{
  m_gamma = gamma;
} // END gamma()


void Properties::brightness(int brightness)
{
  m_brightness = brightness;
} // END brightness()


void Properties::contrast(int contrast)
{
  m_contrast = contrast;
} // END contrast()


void Properties::ownPalette(bool flag)
{
  m_ownPalette = flag;
} // END ownPalette()


void Properties::fastRemap(bool flag)
{
  m_fastRemap = flag;
} // END fastRemap()


void Properties::fastRender(bool flag)
{
  m_fastRender = flag;
} // END fastRender()


void Properties::dither16bit(bool flag)
{
  m_dither16bit = flag;
} // END dither16bit()


void Properties::dither8bit(bool flag)
{
  m_dither8bit = flag;
} // END dither8bit()


void Properties::gammaFactor(unsigned int factor)
{
  m_gammaFactor = factor;
} // END gammaFactor()


void Properties::brightnessFactor(unsigned int factor)
{
  m_brightnessFactor = factor;
} // END brightnessFactor()


void Properties::contrastFactor(unsigned int factor)
{
  m_contrastFactor = factor;
} // END contrastFactor()


void Properties::maxCache(unsigned int maxcache)
{
  m_maxCache = maxcache;
} // END maxCache()


void Properties::downScale(bool flag)
{
  m_downScale = flag;
} // END downScale()


void Properties::upScale(bool flag)
{
  m_upScale = flag;
} // END upScale()


void Properties::maxUpScale(int max)
{
  m_maxUpScale = max;
} // END maxUpScale()


void Properties::defaultValues()
{
  // default values:
  m_startupLogo          = true;
  m_confirmExit          = true;
  m_screenSaverWarning   = true;
  m_base                 = "/cdrom/";
  m_playFilename         = "play.ini";
  m_fullscreen           = false;
  m_disableScreensaver   = false;
  m_defaultImageFilename = "default.jpg";
  m_soundFilename        = "sound.wav";
  m_reportFilename       = "bericht.htm";
  m_autoLoad             = false;
  m_autoStart            = false;
  m_autoQuit             = false;
  m_extSlideChange       = false;
  m_backgroundColor      = QColor(0, 0, 0);
  m_hideMouse            = false;
  m_hideDelay            = 3000;  // 3 sec.
  m_browserName          = "konqueror";

  m_gamma                = 0;
  m_brightness           = 0;
  m_contrast             = 0;
  m_ownPalette           = true;
  m_fastRemap            = true;
  m_fastRender           = true;
  m_dither16bit          = false;
  m_dither8bit           = true;
  m_gammaFactor          = 10;
  m_brightnessFactor     = 10;
  m_contrastFactor       = 10;
  m_maxCache             = 32768; // 32 MB
  
  m_brightnessSteps      = 1;
  m_contrastSteps        = 1;
  m_gammaSteps           = 1;
  m_scrollSteps          = 1;
  m_zoomSteps            = 1.5;
  m_maxWidth             = 8192;
  m_maxHeight            = 8192;
  m_isModsEnabled        = true;
  m_downScale            = true;
  m_upScale              = false;
  m_maxUpScale           = 3;

} // END defaultValues()
