/***************************************************************************
    progressline.h  -  Fortschrittsanzeige
    --------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.4 $
    CVS-ID    : $Id: progressline.h,v 1.4 2002/11/10 11:35:47 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef PROGRESSLINE_H
#define PROGRESSLINE_H


// Qt include files:
#include <qwidget.h>


// Forward Deklarationen:
class QLabel;
class QSlider;
class QString;


/**
 * <b>Klasse ProgressLine</b>
 *
 * Eine <b>ProgressLine</b> gibt Auskunft ueber die aktuelle Position im
 * Ablauf der Praesentation. Dies geschieht zum Einen durch einen Schieber und
 * zum Anderen durch eine textuelle Darstelleung. Durch Benutzung des Schiebers
 * kann durch die Praesentation gebrowsed werden. Schematisch sieht eine
 * <b>ProgressLine</b> folgendermassen aus:
 * <pre>
 * +-----------------------------------------+
 * | Progress: |--------v----| 40:00 / 60:00 |
 * +-----------------------------------------+
 * </pre>
 * @see QSlider
 *
 * @author Dirk Rosert <dirk@rosert.de>
 * $Revision: 1.4 $
 */
class ProgressLine : public QWidget
{
  Q_OBJECT

public:

  /** */
  ProgressLine(QWidget *parent=0, const char *name=0);

  /** */
  ~ProgressLine();

  /**
   * Setzt den Maximalwert (Dauer der Praesentation in msec.) der
   * Fortschrittsanzeige.
   */
  void setMaxValue(int max);

  /** Gibt den Maximalwert (Laenge der Praesentation) zurueck. */
  int maxValue() const;

  /**
   * Gibt den Wert des <em>Fortschritts</em> zurueck. Der entspricht der
   * aktuellen Position in der Praesentation zurueck.
   */
  int value() const;

  /** Schaltet die Fortschrittsanzeige ein/aus. */
  void setEnabled(bool flag);

  /** Ist die Fortschrittsanzeige ein- oder ausgeschaltet ? */
  bool isEnabled() const;

  /** Gibt die Hoehe dieses Widgets zurueck. */
  int height() const;


signals:

  /**
   * Signalisiert, dass durch Verschiebung des Sliders ein neuer Wert aktuell
   * ist.
   */
  void sigNewValue(int);

  /** @see QSlider#sliderReleased */
  void sliderReleased();

public slots:

  /**
   * Setze neuen Wert. Fuehrt zu einer neuen Slider-Position und neuer
   * aktuellen Zeit.
   */
  void setValue(int value);


protected:

  /** i18n("Progress") */
  QLabel  *m_progLabel;

  /** Stellt die aktuelle Zeit in der Praesentation dar. */
  QLabel  *m_actTime;

  // '/'
  QLabel  *m_slashLabel;

  /** Stellt die Gesamtzeit der Praesentation dar. */
  QLabel  *m_totalTime;

  /**
   * Schieber zur Darstellung der aktuellen Position in der Praesentation, und
   * durch verschieben
   */
  QSlider *m_slider;


private:

  /**
   * Erzeugt der Zeit in msec. eine Zeichenkette der Form <tt>MM:SS</tt>, mit
   * <tt>MM</tt> als zweistellige Minutenzahl und <tt>SS</tt> als
   * zweistellige Sekundenzahl.
   */
  QString msec2str(int msec) const;

};


#endif // END PROGRESSLINE_H
