/***************************************************************************
    progressline.cpp  -  Fortschrittsanzeige
    ----------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.4 $
    CVS-ID    : $Id: progressline.cpp,v 1.4 2002/12/17 19:21:40 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// C include files:
#include <math.h>

// Qt include files:
#include <qlabel.h>
#include <qlayout.h>
#include <qslider.h>
#include <qstring.h>
#include <qtooltip.h>

// KDE include files:
#include <klocale.h>

// Application include files:
#include "progressline.h"


ProgressLine::ProgressLine(QWidget *parent, const char *name ) :
  QWidget(parent, name)
{
  setBackgroundMode(PaletteBase);

  m_progLabel  = new QLabel(i18n("Progress: "), this);
  m_slider     = new QSlider(Qt::Horizontal, this, "progress");
  m_actTime    = new QLabel("00:00", this, "acttime");
  m_slashLabel = new QLabel("/", this, "slash");
  m_totalTime  = new QLabel("00:00", this, "totaltime");

  connect(m_slider, SIGNAL(sliderReleased()), this, SIGNAL(sliderReleased()));

  QVBoxLayout *topLayout = new QVBoxLayout(this, 0, -1, "toplayout");
  QHBoxLayout *progressLayout = new QHBoxLayout(0, 0, -1, "progresslayout");

  topLayout->addLayout(progressLayout);

  progressLayout->addWidget(m_progLabel);
  progressLayout->addWidget(m_slider);
  progressLayout->addWidget(new QLabel(" ", this));
  progressLayout->addWidget(m_actTime);
  progressLayout->addWidget(m_slashLabel);
  progressLayout->addWidget(m_totalTime);
  progressLayout->addWidget(new QLabel(" ", this));

  QToolTip::add(m_actTime, i18n("Actual time since begining of the "
                               "presentation."));
  QToolTip::add(m_totalTime, i18n("Total time of the presentation."));

  setEnabled(true);
} // END ProgressLine()


ProgressLine::~ProgressLine()
{
} // END ProgressLine()


void ProgressLine::setMaxValue(int max)
{
  if ( max < 0 )
    max = 0;

  m_slider->setMaxValue(max);
  m_actTime->setText(msec2str(0));
  m_totalTime->setText(msec2str(max));
} // END setMaxValue()


int ProgressLine::maxValue() const
{
  return m_slider->maxValue();
} // END maxValue()


int ProgressLine::value() const
{
  return m_slider->value();
} // END getPos()


void ProgressLine::setEnabled(bool flag)
{
  m_progLabel->setEnabled(flag);
  m_slider->setEnabled(flag);
  m_actTime->setEnabled(flag);
  m_slashLabel->setEnabled(true);
  m_totalTime->setEnabled(flag);
} // END setEnabled()


bool ProgressLine::isEnabled() const
{
  return m_slider->isEnabled();
} // END setEnabled()


int ProgressLine::height() const
{
  int sliderHeight = m_slider->height();
  int labelHeight  = m_actTime->height();

  return (sliderHeight > labelHeight) ? sliderHeight : labelHeight;
} // END height();


void ProgressLine::setValue(int value)
{
  m_slider->setValue(value);
  m_actTime->setText(msec2str(value));
} // END setValue()


QString ProgressLine::msec2str(int msec) const
{
  double dsecs = (double) msec / 1000.0;
  int     secs = (int) rint(dsecs);

  int minutes = secs / 60;
  int seconds = secs % 60;

  QString minStr = "";
  minStr.sprintf("%i", minutes);
  if ( minutes < 10 )
    minStr = "0" + minStr;

  QString secStr = "";
  secStr.sprintf("%i", seconds);
  if ( seconds < 10 )
    secStr = "0" + secStr;

  return minStr+":"+secStr;
} // END msec2str()
