/***************************************************************************
    ktourpresenterview.cpp  -  Haupt-Widget von KTourPresenter
    ----------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.54 $
    CVS-ID    : $Id: ktourpresenterview.cpp,v 1.54 2002/12/17 19:22:53 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// STL include files:
#include <iostream>

// Qt include files:
#include <qapplication.h>
#include <qcolor.h>
#include <qfile.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwidget.h>

// KDE include files:
#include <kcursor.h>
#include <kstddirs.h>
#include <klocale.h>
#include <kimageio.h>

// Application include files:
#include "ktourpresenterview.h"
#include "ktourpresenterdoc.h"
#include "ktourpresenter.h"
#include "progressline.h"
#include "properties.h"


// erzeugt in main.cpp:
extern Properties *properties;


KTourPresenterView::KTourPresenterView(QWidget *parent, const char *name) : 
  QWidget(parent, name)
{
  setBackgroundMode(PaletteBase);

  setMinimumSize(320, 240); // willkuerlich

  KImageIO::registerFormats();

  // Starte im Fensterdarstellungsmodus
  currMode = Window;

  /* Widgets:
     -------- */

  m_image = new ImageWidget(this, "image");

  // Drag&Drop-Event:
  connect(m_image, SIGNAL(sigDropNewURL(const KURL&)),
          topLevelWidget(), SLOT(slotNewURL(const KURL&)));
  
  // Popup-Menue:
  connect(m_image, SIGNAL(sigPopup(const QPoint&)),
          topLevelWidget(), SLOT(slotShowPopup(const QPoint&)));

  // Fortschrittszeile:
  progress = new ProgressLine(this, "progress");
  connect(progress, SIGNAL(sliderReleased()), this, SLOT(slotNewValue()));
  /*
  // *** FIXME: vvv statt ^^^; klappt bisher noch nicht ! Beim Diawechsel
  //                           kommt es zu einer Art Hall
  //connect(slider, SIGNAL(valueChanged(int)), this, SLOT(slotNewValue(int)));
  */

  /* Layout:
     ------- */
  
  QVBoxLayout *topLayout = new QVBoxLayout(this, 0, -1, "toplayout");

  topLayout->addWidget(m_image, 1);
  topLayout->addWidget(progress);

  progress->setEnabled(false);

  if ( parent )
    parent->installEventFilter(this);

} // END KTourPresenterView()


KTourPresenterView::~KTourPresenterView()
{
} // END ~KTourPresenterView()


KTourPresenterDoc *KTourPresenterView::getDocument() const
{
  KTourPresenterApp *theApp = (KTourPresenterApp *) parentWidget();

  return theApp->getDocument();
} // END getDocument()


void KTourPresenterView::setAutoHideEnabled(bool flag)
{
  m_image->setAutoHideEnabled(flag);
} // END setAutoHideEnabled()


void KTourPresenterView::loadImage(const QString& filename)
{
  currImageFilename = filename;

  m_image->loadImage(filename);
  
} // END loadImage


bool KTourPresenterView::cacheImage(const QString& filename)
{
  return m_image->cacheImage(filename);
} // END cacheImage()


bool KTourPresenterView::eventFilter(QObject *o, QEvent *e)
{
  switch ( e->type() )
  {  
    case QEvent::Wheel:
      cerr << "wheel" << endl;
      wheelEvent(static_cast<QWheelEvent*>(e));
      return true;
      break;

    default:
      break;
  } // END switch
  
  return QWidget::eventFilter(o, e);
} // END eventFilter()


void KTourPresenterView::wheelEvent(QWheelEvent *e)
{
  int delta = e->delta();

  if ( delta < 0 )
    emit sigPrev();
  else
    if ( delta > 0 )
      emit sigNext();

  e->accept();
} // END wheelEvent()


void KTourPresenterView::resizeEvent(QResizeEvent *re)
{
  QSize newsize = re->size();

  int viewWidth  = newsize.width();
  int viewHeight = newsize.height() - progress->height();

  m_image->resize(viewWidth, viewHeight);
  
  // *** FIXME: ugly hack :-(
  if ( currMode == Window )
    m_image->setFixedSize(QSize(viewWidth, viewHeight));
  
} // END resizeEvent()


void KTourPresenterView::showImage()
{
  // zeige die Pixmap:
  repaint();
} // END showImage()


void KTourPresenterView::setEnabled(bool flag)
{
  progress->setEnabled(flag);

  // weiteres ein-/ausschalten (?)
  
} // END setProgressEnabled()


void KTourPresenterView::setSliderMax(int maxValue)
{
  progress->setMaxValue(maxValue);
} // END setSliderMax()


void KTourPresenterView::updateTotalTime(int msec)
{
  progress->setValue(msec);
} // END updateTotalTime()


void KTourPresenterView::updateActTime(int msec)
{
  progress->setValue(msec);
} // END updateActTime()


void KTourPresenterView::updateSlider(int msec)
{
  progress->setValue(msec);
} // END updateSlider()


KTourPresenterView::ViewMode KTourPresenterView::viewMode() const
{
  return currMode;
} // END viewMode()


void KTourPresenterView::slotNewValue()
{
  emit sigNewSliderPos(progress->value());
} // END slotNewValue()


void KTourPresenterView::slotNewValue(int value)
{
  emit sigNewSliderPos(value);
} // END slotNewValue()


void KTourPresenterView::slotReset()
{
  progress->setValue(0);
  progress->setEnabled(false);

  // loesche Image:
  m_image->eraseImage();

  if ( currMode == Fullscreen )
    slotToggleFullscreen();

} // END slotReset()


void KTourPresenterView::slotBackgroundColorChanged(const QColor& color)
{
  m_image->setBackgroundColor(color);
} // END slotBackgroundColorChanged()


void KTourPresenterView::slotModifierChanged()
{
  // teile dem Image mit, dass sich Modifier geaendert haben !!!
  m_image->setBrightness(properties->brightness());
  m_image->setContrast(properties->contrast());
  m_image->setGamma(properties->gamma());
} // END slotModifierChanged()


void KTourPresenterView::slotMoreBrightness()
{
  m_image->slotMoreBrightness();
} // END slotMoreBrightness()


void KTourPresenterView::slotLessBrightness()
{
  m_image->slotLessBrightness();
} // END slotLessBrightness()


void KTourPresenterView::slotMoreContrast()
{
  m_image->slotMoreContrast();
} // END slotMoreContrast()


void KTourPresenterView::slotLessContrast()
{
  m_image->slotLessContrast();
} // END slotLessContrast()


void KTourPresenterView::slotMoreGamma()
{
  m_image->slotMoreGamma();
} // END slotMoreGamma()


void KTourPresenterView::slotLessGamma()
{
  m_image->slotLessGamma();
} // END slotLessGamma()


void KTourPresenterView::slotResetModifier()
{
  properties->brightness(0);
  properties->contrast(0);
  properties->gamma(0);

  // *** FIXME: signalisiere, dass sich die Modifier geaendert haben !
  m_image->setBrightness(0);
  m_image->setContrast(0);
  m_image->setGamma(0);
} // END slotResetModifier()


void KTourPresenterView::slotToggleFullscreen()
{
  ViewMode oldMode;

  if ( currMode == Window )
  {
#ifndef NDEBUG
    cerr << "KTourPresenterView::slotToggleFullscreen() "
         << "Window -> Fullscreen" << endl;
#endif

    // nun Vollbildmodus:
    currMode = Fullscreen;
    oldMode = Window;

    m_image->setFullscreenEnabled(true);
  }
  else
  {
#ifndef NDEBUG
    cerr << "KTourPresenterView::slotToggleFullscreen() "
         << "Fullscreen -> Window" << endl;
#endif

    // nun Anwendungsfenstermodus:
    currMode = Window;
    oldMode = Fullscreen;

    m_image->setFullscreenEnabled(false);
    
  } // END if

  // setze Modifier im neuen Modus
  m_image->setBrightness(properties->brightness());
  m_image->setContrast(  properties->contrast());
  m_image->setGamma(     properties->gamma());

  // lade aktuelle Grafik fuer neuen Modus:
  m_image->loadImage(currImageFilename);

} // END slotToggleFullscreen()


void KTourPresenterView::slotHideMouseChanged(bool flag)
{
  setAutoHideEnabled(flag);
} // END slotHideMouseChanged()
