/***************************************************************************
    imagecache.h  -  Repraesentiert einen Cache von KTourImage-Objekte
    ------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.15 $
    CVS-ID    : $Id: imagecache.h,v 1.15 2002/12/04 11:54:33 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * basiert auf KuickShow 0.8.2 von Carsten Pfeiffer <pfeiffer@kde.org>
 */

 
#ifndef IMAGECACHE_H
#define IMAGECACHE_H


// Qt include files:
#include <qlist.h>
#include <qvariant.h>
#include <qwidget.h>

// include those AFTER Qt-includes!
#include <Imlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

// Application include files:
#include "ktourimage.h"


/**
 * <b>Klasse ImageCache</b>
 *
 * Repraesentiert einen Cache von KTourImage-Objekte.
 *
 * @see KTourImage
 * @author Dirk Rosert <dirk@rosert.de>
 * $Revision: 1.15 $
 */
class ImageCache : public QObject
{
  Q_OBJECT

public: // methods:

  /**
   * Erzeugt einen Cache fuer KTourImage Objekte der Groesse @p maxImage.
   */
  ImageCache(ImlibData *id, int maxImages=1);

  /** Zerstoerrt den Cache. */
  ~ImageCache();

  /** Setzt nachtraeglich die Groesse des Caches auf @p maxImage Elemente. */
  void setMaxImages(int maxImages);

  /** Liefert die Groesse des Caches. */
  int maxImages() const;

  /**
   * Liefert einen Zeiger auf das KTourImage-Objekt, dessen Dateiname
   * @p file ist. Befindet sich Das Image nicht im Cache, dann wird dieses
   * geladen und der Modifier @p mod angewandt.
   */
  KTourImage *getImage(const QString& file, ImlibColorModifier mod,
                       bool paintFlag=false);


signals:

  /** Signalisiere, dass das geforderte Image geladen wird. */
  void sigBusy();

  /** Signalisiere, dass das Laden beendet wurde. */
  void sigIdle();


private: // attributs:

  int m_maxImages;
  QStringList fileList;
  QList<KTourImage> kuickList;
  ImlibData *m_id;
  int	idleCount;

  static const int ImlibOffset = 256;


private slots:

  /** */
  void slotBusy();

  /** */
  void slotIdle();

};


#endif // END IMAGECACHE_H
