/***************************************************************************
    globals.h  -  Definiert Globales ;-)
    ---------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.7 $
    CVS-ID    : $Id: globals.h,v 1.7 2002/12/16 21:14:25 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * basiert auf KuickShow 0.8.2 von Carsten Pfeiffer <pfeiffer@kde.org>
 */


#ifndef GLOBALS_H
#define GLOBALS_H


// Qt include files:
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#ifndef NDEBUG
#include <qdatetime.h>
#endif

// KDE include files:
#include <kwin.h>
#include <kwinmodule.h>


/**
 * <b>Klasse Globals</b>
 *
 * Definiert Globales ;-)
 *
 * @author Dirk Rosert <dirk@rosert.de>
 * $Revision: 1.7 $
 */
class Globals
{
public:

  /** */
  static QRect workArea()
  {
    return self()->winModule.workArea();
  }

  /** */
  static QSize frameSize( WId win = 0L )
  {
    if ( win )
    {
      KWin::Info info = KWin::info( win );
      int wborder = info.frameGeometry.width() - info.geometry.width();
      int hborder = info.frameGeometry.height() - info.geometry.height();

      if ( wborder || hborder )
      {
        // we get a 0,0 border when not shown
        s_frameSize.setWidth(wborder);
        s_frameSize.setHeight(hborder);
      }
    }

    if ( !s_frameSize.isValid() )
      return QSize( 0, 0 );

    return s_frameSize;
  }

  /** Zeigt auf sich. */
  static Globals *self()
  {
    if ( !s_self )
    {
      s_self = new Globals;
    }
    
    return s_self;
  }

  /** Ersetzt in einem String die Backslash's durch Slash's. */
  static void backslashToSlash(QString& str)
  {
    int bsplashpos;
    const QString backslash("\\");

    bsplashpos = str.find(backslash);
    while ( bsplashpos != -1 )
    {
      str[bsplashpos] = '/';
      bsplashpos = str.find(backslash);
    } // END while
  }

#ifndef NDEBUG
  /** */
  static const QString currTime()
  {
    QTime ct = QTime::currentTime();

    QString hStr;
    hStr.sprintf("%d", ct.hour());
    if ( ct.hour() < 10 )
      hStr = "0" + hStr;

    QString mStr;
    mStr.sprintf("%d", ct.minute());
    if ( ct.minute() < 10 )
      mStr = "0" + mStr;

    QString sStr;
    sStr.sprintf("%d", ct.second());
    if ( ct.second() < 10 )
      sStr = "0" + sStr;

    QString msStr;
    msStr.sprintf("%d", ct.msec());
    if ( ct.msec() < 10 )
      msStr = "00" + msStr;
    else
      if ( ct.msec() < 100 )
        msStr = "0" + msStr;

    return hStr + ":" + mStr + ":" + sStr + "," + msStr;
  }

  /** */
  static const QString bool2qstring(bool flag)
  {
    return flag ? "true" : "false";
  }
#endif

  /** */
  KWinModule winModule;


private:

  /** */
  Globals() {}
    
  static Globals *s_self;
  static QSize s_frameSize;
};


#endif // END GLOBALS_H
