/***************************************************************************
    configuredialog.h  -  Konfigurations-Dialog von KTourPresenter
    -----------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.36 $
    CVS-ID    : $Id: configuredialog.h,v 1.36 2002/11/08 15:34:36 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CONFIGUREDIALOG_H
#define CONFIGUREDIALOG_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE include files:
#include <kdialogbase.h>

// Forward-Deklarationen:
class QCheckBox;
class QLineEdit;
class QPushButton;
class QString;
class KAccel;
class KColorButton;
class KEditToolbarWidget;
class KIntNumInput;
class KMainWindow;
class ImageWidget;


/**
 * Konfigurations-Dialog von KTourPresenter.
 *
 * Konfiguriert werden kann:
 * <ul>
 *   <li><b>Allgemeine Einstellungen</b>
 *     <ul>
 *       <li>Basispfad der Praesentation (z.B. <tt>/cdrom/</tt>)
 *       <li>Name der Praesentationsdatei (z.B <tt>play.ini</tt>)
 *       <li>Dateiname der voreingestellten Grafik (z.B.
 *           <tt>default.jpg</tt>)
 *       <li>Soll interner Berichts-Browser benutzt werden ?
 *       <li>ggf. Name des Browsers (z.B. <tt>konqueror</tt>)
 *     </ul>
 *   <li><b>Praesentations-Einstellungen</b>
 *     <ul>
 *       <li>Soll beim Programmstart die Praesentation geladen werden ?
 *       <li>Soll die geladene Praesentation gestartet werden ?
 *       <li>Die Hintergrundfarbe (z.B. Schwarz)
 *     </ul>
 *   <li><b>Bilder-Einstellungen</b>
 *     <ul>
 *       <li>Soll ein Bild verkleinert werden, wenn es zu Gross ist ?
 *       <li>Soll ein Bild vergroessert werden, wenn es zu klein ist, und
 *           wenn ja, bis zu welchem Faktor (z.B. <tt>3</tt>)
 *       <li>Soll ein schnelleres Render benutzt werden ?
 *       <li>Soll im HiColor-Modus (15/16 Bit) gedithert werden ?
 *       <li>Soll im LowColor-Modus (8 Bit) gedithert werden ?
 *       <li>Soll das Programm im LowColor-Modus eine eigene Farbpalette
 *           benutzt werden ?
 *       <li>Soll ein schnelles Farbpaletten-Remapping benutzt werden ?
 *       <li>Der Helligkeitswert zwischen -256 und +256 (z.B. <tt>0</tt>)
 *       <li>Der Kontrastwert zwischen -256 und +256 (z.B. <tt>0</tt>)
 *       <li>Der Gamma-Wert zwischen -256 und +256 (z.B. <tt>0</tt>)
 *     </ul>
 *   <li><b>Tasten-Einstellungen</b> fuer verschieden Aktionen
 *   <li><b>Werkzeugleisten-Einstellungen</b> fuer die dargestellten Symbole
 *       in der Werkzeugleiste
 * </ul>
 * @see Properties
 *
 * @author Dirk Rosert <dirk@rosert.de>
 * $Revision: 1.36 $
 */
class ConfigureDialog : public KDialogBase
{
  Q_OBJECT
  
public:

  /**
   * Erzeugt den Konfigurationsdialog. Uebergeben werde u.a. die
   * die Anwendungs-Shortcuts @p accel, die in diesem Dialog geaendert werden
   * koennen.
   */
  ConfigureDialog(QWidget *parent=0, const char *name=0, KAccel *accel=0,
                  KMainWindow *toplevel=0, bool modal=false);

  ~ConfigureDialog();

  /**
   * Setzt die Eingabe-Elemente des Dialoges mit den Werten aus Properties.
   */
  void setValues();

  
signals:

  /**
   * Signalisiert, dass die Hintergrundfarbe fuer die Praesentation geaendert
   * wurde.
   */
  void sigBackgroundColorChanged(const QColor&);

  /**
   * Signalisiert, dass Helligkeits-, Kontrast- oder Gamma-Wert geaendert
   * wurde.
   */
  void sigModifierChanged();

  /** Signalisiert, dass die Werkzeugleiste geaendert wurde. */
  void sigToolbarChanged();

  /**
   * Signalisiert, dass die Einstellung zur Abschaltung des Bildschirmschoners
   * geaendert wurde.
   */
  void sigDisableScreensaver(bool);

  /**
   * Signalisiert, dass die Einstellung zur Verbergung des Mauszeigers
   * geaendert wurde.
   */
  void sigHideMouseChanged(bool);


protected slots:

  /** Oeffnet eine Dateiauswahlbox zur Auswahl des Basispfades. */
  void slotOpenBasePath();

  /** Oeffnet eine Dateiauswahlbox zur Auswahl der Abspieldatei. */
  void slotOpenPlayFile();

  /** Oeffnet eine Dateiauswahlbox zur Auswahl des Default-Bildes. */
  void slotOpenDefaultImg();

  /** Oeffnet eine Dateiauswahlbox zur Auswahl des Tourberichts. */
  void slotOpenReportFile();

  /**
   * Oeffnet eine Dateiauswahlbox zur Auswahl des Browsers fuer den
   * Tourbericht.
   */
  void slotOpenBrowser();
  
  /** Wird aufgerufen, wenn die "Ok"-Taste gedrueckt wurde. */
  void slotOk();

  /** Wird aufgerufen, wenn die "Anwenden"-Taste gedrueckt wurde. */
  void slotApply();

  /** Wird aufgerufen, wenn die "Voreinstellung"-Taste gedrueckt wurde. */
  void slotDefault();

  /**
   * Wenn upScale erlaubt wurde, dann kann der maximale Vergroesserungsfaktor
   * eingestellt werden.
   */
  void slotEnableMaxScale(bool);

  /** */
  void slotScreenSaverWarning(bool);

  /** */
  void slotHideMouseToggled(bool);


private: // types:

  /** Widgets fuer allgemeine Einstellungen. */
  struct SGeneralPage
  {
    QString      basePath;
    QString      playFile;
    QString      defaultImgFile;
    QString      reportFile;
    QLineEdit   *basePathLE;
    QLineEdit   *playFileLE;
    QLineEdit   *defaultImgFileLE;
    QLineEdit   *reportFileLE;
    QPushButton *basePathPB;
    QPushButton *playFilePB;
    QPushButton *defaultImgFilePB;
    QPushButton *reportFilePB;

    QLineEdit   *browserNameLE;
    QPushButton *browserNamePB;
  };
  
  /** Widgets fuer die Praesentations-Konfiguration. */
  struct SPresentationPage
  {
    QCheckBox    *autoLoadCB;
    QCheckBox    *autoStartCB;
    QCheckBox    *autoQuitCB;
    QCheckBox    *fullscreenCB;
    QCheckBox    *disableSSaverCB;
    QCheckBox    *hideMouseCB;
    KColorButton *backgroundButton;
    KIntNumInput *hideDelayNUM;
  };

  /** Widgets fuer die Imlib-Konfiguration. */
  struct SImagePage
  {
    // Skalieren:
    QCheckBox    *cbDownScale;
    QCheckBox    *cbUpScale;
    KIntNumInput *sbMaxUpScaleFactor;

    // Qualitaet / Geschwindigkeit:
    QCheckBox    *cbFastRender;
    QCheckBox    *cbDither16bit;
    QCheckBox    *cbDither8bit;
    QCheckBox    *cbOwnPalette;
    QCheckBox    *cbFastRemap;
    KIntNumInput *maxCacheSpinBox;

    // Anpassen:
    KIntNumInput *sbBrightness;
    KIntNumInput *sbContrast;
    KIntNumInput *sbGamma;

    // Vorschau:
    ImageWidget  *imOriginal;
    ImageWidget  *imFiltered;
  };
  
  /** */
  struct SToolbarPage
  {
    KEditToolbarWidget *edit;
  };


private: // methods:

  /** Initialisiere ... */
  void setupGeneralPage();
  void setupPresentationPage();
  void setupImagePage();
  void setupToolbarPage();

  void setValuesGeneral();
  void setValuesPresentation();
  void setValuesImage();

  void applyGeneral();
  void applyPresentation();
  void applyImage();


private slots:

  /** Das Preview-Image soll angepasst werden. */
  void slotUpdatePreview();

  /** Kein gueltiges Preview-Image (z.B. Fehler beim Laden). */
  void slotNoImage();

  /** */
  void slotUseOwnPalette();

  /** Wurde die Einstellung der Werkzeugleiste geaendert ? */
  void slotToolbarDirty(bool);


private: // attributes:

  SGeneralPage      m_general;
  SPresentationPage m_presentation;
  SImagePage        m_image;
  SToolbarPage      m_toolbar;

  KAccel           *m_accel;
  KMainWindow      *m_toplevel;

  int m_oldBrightness;
  int m_oldContrast;
  int m_oldGamma;

  bool m_toolbarDirty;

};


#endif // END CONFIGUREDIALOG_H
