/***************************************************************************
    cfg_image.cpp  -  Konfiguration fuer Fotos
    -------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.3 $
    CVS-ID    : $Id: cfg_image.cpp,v 1.3 2002/12/03 14:33:36 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Qt include files:
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtabwidget.h>
#include <qtooltip.h>
#include <qvgroupbox.h>
#include <qwhatsthis.h>

// KDE include files:
#include <kiconloader.h>
#include <klocale.h>
#include <knuminput.h>
#include <kstandarddirs.h>

// Application include files:
#include "configuredialog.h"
#include "imagewidget.h"
#include "properties.h"


// erzeugt in main.cpp:
extern Properties *properties;


void ConfigureDialog::setupImagePage()
{
  QFrame *page = addPage(i18n("Image"), i18n("Image Settings"),
                         BarIcon("background", KIcon::SizeMedium));
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());

  // *** Widgets ***

  // Tab-Widget:
  QTabWidget *tabWidget   = new QTabWidget(page, "tabwidget");
  QWidget    *tabContent1 = new QWidget(tabWidget, "tabcontent1");
  QWidget    *tabContent2 = new QWidget(tabWidget, "tabcontent2");

  // Skalieren:
  QGroupBox *gbScale = new QGroupBox(i18n("Scaling"), tabContent1);
  m_image.cbDownScale =
    new QCheckBox(i18n("Shrink image to screensize, if larger"),
                  gbScale, "shrinktoscreen");
  m_image.cbDownScale->setChecked(properties->downScale());

  m_image.cbUpScale = new QCheckBox(
    i18n("Scale image to screensize, if smaller, up to factor:"),
                  gbScale, "upscale checkbox" );
  m_image.cbUpScale->setChecked(properties->upScale());
  connect(m_image.cbUpScale, SIGNAL(toggled(bool)),
                             SLOT(slotEnableMaxScale(bool)));

  m_image.sbMaxUpScaleFactor =
    new KIntNumInput(gbScale, "upscale factor" );
  m_image.sbMaxUpScaleFactor->setRange(1, 100, 1, false);
  m_image.sbMaxUpScaleFactor->setValue(properties->maxUpScale());
  m_image.sbMaxUpScaleFactor->setEnabled(properties->upScale());

  // Qualitaet / Geschwindigkeit:
  QVGroupBox *vgbQual = new QVGroupBox(i18n("Quality / Speed"), tabContent1,
                                     "qualitybox");

  m_image.cbFastRender = new QCheckBox(i18n("Fast rendering"), vgbQual,
                                      "fastrender");
  m_image.cbFastRender->setChecked(properties->fastRender());

  m_image.cbDither16bit =
    new QCheckBox(i18n("Dither in HiColor (15/16bit) modes"), vgbQual,
                  "dither16bit");
  m_image.cbDither16bit->setChecked(properties->dither16bit());

  m_image.cbDither8bit =
    new QCheckBox(i18n("Dither in LowColor (<=8bit) modes"), vgbQual,
                  "dither8bit");
  m_image.cbDither8bit->setChecked(properties->dither8bit());

  m_image.cbOwnPalette =
    new QCheckBox( i18n("Use own color palette"), vgbQual, "pal");
  m_image.cbOwnPalette->setChecked(properties->ownPalette());
  connect(m_image.cbOwnPalette, SIGNAL(clicked()),
          this, SLOT(slotUseOwnPalette()));

  m_image.cbFastRemap =
    new QCheckBox(i18n("Fast palette remapping"), vgbQual, "remap");
  m_image.cbFastRemap->setChecked(properties->fastRemap());

  m_image.maxCacheSpinBox = new KIntNumInput(vgbQual, "editmaxcache");
  m_image.maxCacheSpinBox->setLabel(i18n("Maximum cache size (MB): "),
                                   AlignVCenter);
  m_image.maxCacheSpinBox->setRange(0, 500, 1);
  m_image.maxCacheSpinBox->setValue(properties->maxCache() / 1024);
  QToolTip::add(m_image.maxCacheSpinBox, i18n("0 = don't limit"));

  // Anpassen:
  QVGroupBox *vgbAdjust = new QVGroupBox(i18n("Adjustments"), tabContent2);

  m_image.sbBrightness =
    new KIntNumInput(vgbAdjust, "brightness spinbox");
  m_image.sbBrightness->setRange(-256, 256, 1, true);
  m_image.sbBrightness->setValue(properties->brightness());
  m_image.sbBrightness->setLabel(i18n("Brightness"), AlignVCenter);

  m_image.sbContrast =
    new KIntNumInput(m_image.sbBrightness, 0, vgbAdjust, 10,
                     "contrast spinbox");
  m_image.sbContrast->setRange(-256, 256, 1, true);
  m_image.sbContrast->setValue(properties->contrast());
  m_image.sbContrast->setLabel(i18n("Contrast"), AlignVCenter);

  m_image.sbGamma =
    new KIntNumInput(m_image.sbContrast, 0, vgbAdjust, 10,
                     "gamma spinbox");
  m_image.sbGamma->setRange(-256, 256, 1, true);
  m_image.sbGamma->setValue(properties->gamma());
  m_image.sbGamma->setLabel(i18n("Gamma"), AlignVCenter);

  QVBoxLayout *gbScaleLayout =
    new QVBoxLayout(gbScale, 10, 5, "scale layout");
  QHBoxLayout *scaleSubLayout = new QHBoxLayout( -1, "scale sublayout" );
  gbScaleLayout->addSpacing(6);
  gbScaleLayout->addWidget(m_image.cbDownScale, 0, AlignLeft );
  gbScaleLayout->addLayout(scaleSubLayout, 0);
  scaleSubLayout->addWidget(m_image.cbUpScale);
  scaleSubLayout->addWidget(m_image.sbMaxUpScaleFactor);

  // Preview:
  QGroupBox *gbPreview = new QGroupBox(i18n("Preview"), vgbAdjust);
  gbPreview->setAlignment(AlignCenter);

  QLabel *lbImOriginal = new QLabel(i18n("Original"), gbPreview);
  m_image.imOriginal = new ImageWidget(gbPreview, "original image");

  QLabel *lbImFiltered = new QLabel(i18n("Modified"), gbPreview);
  m_image.imFiltered = new ImageWidget(gbPreview, "filtered image");
  connect(m_image.imFiltered, SIGNAL(destroyed()), SLOT(slotNoImage()));


  // Preview-Image:
  QString filename = locate("data", "ktourpresenter/preview.png");

  if ( !m_image.imOriginal->loadImage(filename, true) )
  {
    m_image.imOriginal = 0L;
  }
  else
  {
    QWhatsThis::add(m_image.imOriginal, i18n("The original preview image."));
    m_image.imOriginal->setFixedSize(m_image.imOriginal->size());
  } // END if

  if ( !m_image.imFiltered->loadImage(filename, true) )
  {
    m_image.imFiltered = 0L;
  }
  else
  {
    QWhatsThis::add(m_image.imFiltered, i18n("The filtered preview image."));
    m_image.imFiltered->setFixedSize(m_image.imFiltered->size());
  } // END if

  //  *** Layout ***
  QVBoxLayout *topLayoutGeneral =
    new QVBoxLayout(tabContent1, 0, spacingHint());
  QVBoxLayout *topLayoutModify =
    new QVBoxLayout(tabContent2, 0, spacingHint());

  QGridLayout *gPreviewLayout =
    new QGridLayout(gbPreview, 2, 2, 0, -1, "previewlayout");

  topLayoutGeneral->addWidget(gbScale);
  topLayoutGeneral->addWidget(vgbQual);
  topLayoutModify->addWidget(vgbAdjust);

  tabWidget->insertTab(tabContent1, i18n("General"));
  tabWidget->insertTab(tabContent2, i18n("Adjust"));

  topLayout->addWidget(tabWidget);

  if ( m_image.imOriginal && m_image.imFiltered )
  {
    gPreviewLayout->setMargin(10);
    gPreviewLayout->setSpacing(KDialog::spacingHint());
    gPreviewLayout->addWidget(lbImOriginal, 0, 0, AlignCenter);
    gPreviewLayout->addWidget(lbImFiltered, 0, 1, AlignCenter | AlignTop);
    gPreviewLayout->addWidget(m_image.imOriginal, 1, 0, AlignCenter);
    gPreviewLayout->addWidget(m_image.imFiltered, 1, 1,
                                                  AlignCenter | AlignTop);
  } // END if

  // *** Connects ***
  connect(m_image.sbBrightness, SIGNAL(valueChanged(int)),
                                SLOT(slotUpdatePreview()));
  connect(m_image.sbContrast,   SIGNAL(valueChanged(int)),
                                SLOT(slotUpdatePreview()));
  connect(m_image.sbGamma,      SIGNAL(valueChanged(int)),
                                SLOT(slotUpdatePreview()));

} // END setupImagePage()


void ConfigureDialog::setValuesImage()
{
  m_image.cbDownScale->setChecked(properties->downScale());
  m_image.cbUpScale->setChecked(properties->upScale());
  m_image.sbMaxUpScaleFactor->setValue(properties->maxUpScale());
  m_image.cbFastRender->setChecked(properties->fastRender());
  m_image.cbDither16bit->setChecked(properties->dither16bit());
  m_image.cbDither8bit->setChecked(properties->dither8bit());
  m_image.cbOwnPalette->setChecked(properties->ownPalette());
  m_image.cbFastRemap->setChecked(properties->fastRemap());
  m_image.maxCacheSpinBox->setValue(properties->maxCache() / 1024);
  m_image.sbBrightness->setValue(properties->brightness());
  m_image.sbContrast->setValue(properties->contrast());
  m_image.sbGamma->setValue(properties->gamma());
} // END setValuesImage()


void ConfigureDialog::applyImage()
{
  properties->downScale(m_image.cbDownScale->isChecked());
  properties->upScale(m_image.cbUpScale->isChecked());
  properties->maxUpScale(m_image.sbMaxUpScaleFactor->value());
  properties->fastRender(m_image.cbFastRender->isChecked());
  properties->dither16bit(m_image.cbDither16bit->isChecked());
  properties->dither8bit(m_image.cbDither8bit->isChecked());
  properties->ownPalette(m_image.cbOwnPalette->isChecked());
  properties->fastRemap(m_image.cbFastRemap->isChecked());
  properties->maxCache(m_image.maxCacheSpinBox->value() * 1024);

  int brightness = m_image.sbBrightness->value();
  int contrast   = m_image.sbContrast->value();
  int gamma      = m_image.sbGamma->value();

  if ( m_oldBrightness != brightness ||
       m_oldContrast   != contrast   ||
       m_oldGamma      != gamma         )
  {
    properties->brightness(brightness);
    properties->contrast(contrast);
    properties->gamma(gamma);

    emit sigModifierChanged();
  } // END if

} // END applyImage()


void ConfigureDialog::slotEnableMaxScale(bool flag)
{
  m_image.sbMaxUpScaleFactor->setEnabled(flag);
} // END slotEnableMaxScale()


void ConfigureDialog::slotUpdatePreview()
{
  if ( !m_image.imFiltered )
    return;

  m_image.imFiltered->setAutoRender(false);
  m_image.imFiltered->setBrightness(m_image.sbBrightness->value());
  m_image.imFiltered->setContrast(  m_image.sbContrast->value());
  m_image.imFiltered->setGamma(     m_image.sbGamma->value());
  m_image.imFiltered->updateImage();
  m_image.imFiltered->setAutoRender(true);

} // END slotUpdatePreview()


void ConfigureDialog::slotNoImage()
{
  m_image.imFiltered = 0L;
} // END slotNoImage()


void ConfigureDialog::slotUseOwnPalette()
{
  m_image.cbFastRemap->setEnabled(m_image.cbOwnPalette->isChecked());
} // END slotUseOwnPalette()
