/***************************************************************************
    cfg_general.cpp  -  Allgemeine Konfiguration
    ---------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.2 $
    CVS-ID    : $Id: cfg_general.cpp,v 1.2 2002/11/08 15:34:36 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Qt include files:
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qwhatsthis.h>

// KDE include files:
#include <kfiledialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kurl.h>

// Application include files:
#include "configuredialog.h"
#include "properties.h"


// erzeugt in main.cpp:
extern Properties *properties;


void ConfigureDialog::setupGeneralPage()
{
  QFrame *page = addPage( i18n("General"), i18n("General Settings"),
                          BarIcon("misc", KIcon::SizeMedium) );
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());


  // <<< Groupe box: file and directory names >>>
  QGroupBox *fileDirGroup;
  fileDirGroup = new QGroupBox(page, "filedirgroup");

  QGridLayout *gridLayout1 =
    new QGridLayout(fileDirGroup, 4, 3, 20, 10, "filedirgroup");
  fileDirGroup->setTitle(i18n("File and directory names"));

  // base:
  QLabel *basePathLabel = new QLabel(i18n("Base path of the presentation"),
                                     fileDirGroup, "basepathlabel");
  m_general.basePathLE = new QLineEdit(properties->base(), fileDirGroup,
                                      "basepathlineedit");
  m_general.basePathPB = new QPushButton(fileDirGroup, "basepathselect");
  m_general.basePathPB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.basePathPB, SIGNAL(clicked()),
          this, SLOT(slotOpenBasePath()));
  gridLayout1->addWidget(basePathLabel,        0, 0);
  gridLayout1->addWidget(m_general.basePathLE, 0, 1);
  gridLayout1->addWidget(m_general.basePathPB, 0, 2);
  QString baseTT =
    i18n("In opposition to the Windows application KTourPresenter "
         "is not located on the tour CD. KTourPresenter needs to "
         "know where the presentation lies (e.g. <tt>/cdrom</tt> "
         "or <tt>/media/cdrom</tt>).");
  QWhatsThis::add(m_general.basePathLE, baseTT);

  // play file:
  QLabel *playFileLabel =
    new QLabel(i18n("Name of the presentation file"), fileDirGroup,
                    "playfilelabel");
  m_general.playFileLE =
    new QLineEdit(properties->playFilename(), fileDirGroup,
                  "playfilelineedit");
  m_general.playFilePB = new QPushButton(fileDirGroup, "playfileselect");
  m_general.playFilePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.playFilePB, SIGNAL(clicked()),
          this, SLOT(slotOpenPlayFile()));
  gridLayout1->addWidget(playFileLabel,        1, 0);
  gridLayout1->addWidget(m_general.playFileLE, 1, 1);
  gridLayout1->addWidget(m_general.playFilePB, 1, 2);
  QString playTT =
    i18n("");
  QWhatsThis::add(m_general.playFileLE, playTT);

  // default image:
  QLabel *defaultImgFileLabel =
    new QLabel(i18n("Filename of the default image"), fileDirGroup,
                    "defimgfilelabel");
  m_general.defaultImgFileLE =
    new QLineEdit(properties->defaultImageFilename(), fileDirGroup,
                  "defimgfilelineedit");
  m_general.defaultImgFilePB =
    new QPushButton(fileDirGroup, "defimgfileselect");
  m_general.defaultImgFilePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.defaultImgFilePB, SIGNAL(clicked()),
          this, SLOT(slotOpenDefaultImg()));
  gridLayout1->addWidget(defaultImgFileLabel,        2, 0);
  gridLayout1->addWidget(m_general.defaultImgFileLE, 2, 1);
  gridLayout1->addWidget(m_general.defaultImgFilePB, 2, 2);
  QString defaultTT =
    i18n("Name of the image file that will be shown when the presentation "
         "is not running.");
  QWhatsThis::add(m_general.defaultImgFileLE, defaultTT);

  // report filename
  QLabel *reportFileLabel =
    new QLabel(i18n("Name of the report file"), fileDirGroup,
               "reportfilelabel");
  m_general.reportFileLE =
    new QLineEdit(properties->reportFilename(), fileDirGroup,
                  "reportfilelineedit");
  m_general.reportFilePB = new QPushButton(fileDirGroup, "reportfileselect");
  m_general.reportFilePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.reportFilePB, SIGNAL(clicked()),
          this, SLOT(slotOpenReportFile()));
  gridLayout1->addWidget(reportFileLabel,        3, 0);
  gridLayout1->addWidget(m_general.reportFileLE, 3, 1);
  gridLayout1->addWidget(m_general.reportFilePB, 3, 2);
  QString reportTT =
    i18n("Filename of the tour report. If this file does not exists the "
         "report browser is disabled.");
  QWhatsThis::add(m_general.reportFileLE, reportTT);


  // <<< Groupe box: report browser >>>
  QGroupBox *reportGroup;
  reportGroup = new QGroupBox(page, "reportgroup");

  QGridLayout *gridLayout2 =
    new QGridLayout(reportGroup, 3, 3, 20, 10, "reportgrouplayout");

  reportGroup->setTitle(i18n("Report browser"));

  // name of the browser
  QLabel *browserNameLabel =
    new QLabel(i18n("Name of the browser"), reportGroup, "browsernamelabel");
  m_general.browserNameLE = new QLineEdit(properties->browserName(),
                                         reportGroup, "browsernamelineedit");

  m_general.browserNamePB = new QPushButton(reportGroup, "browsernameselect");
  m_general.browserNamePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.browserNamePB, SIGNAL(clicked()),
          this, SLOT(slotOpenBrowser()));
  gridLayout2->addWidget(browserNameLabel,        1, 0);
  gridLayout2->addWidget(m_general.browserNameLE, 1, 1);
  gridLayout2->addWidget(m_general.browserNamePB, 1, 2);
  QString browserTT =
    i18n("Name of the external browser, e.g. <tt>konqeror</tt>,"
         "<tt>netscape</tt>, <tt>mozilla</tt> or purists maybe "
         "choose <tt>xterm -e lynx</tt> <tt>;-)</tt>");
  QWhatsThis::add(m_general.browserNameLE, browserTT);


  // Layout:
  topLayout->addWidget(fileDirGroup);
  topLayout->addWidget(reportGroup);

} // END setupGeneralPage()


void ConfigureDialog::setValuesGeneral()
{
  m_general.basePathLE->setText(properties->base());
  m_general.defaultImgFileLE->setText(properties->defaultImageFilename());
  m_general.reportFileLE->setText(properties->reportFilename());
  m_general.browserNameLE->setText(properties->browserName());
} // END setValuesGeneral()


void ConfigureDialog::applyGeneral()
{
  properties->base(m_general.basePathLE->text());
  properties->defaultImageFilename(m_general.defaultImgFileLE->text());
  properties->reportFilename(m_general.reportFileLE->text());
  properties->browserName(m_general.browserNameLE->text());
} // END applyGeneral()


void ConfigureDialog::slotOpenPlayFile()
{
  KURL url = KFileDialog::getOpenURL(properties->base(),
        i18n("*.ini|Play File (*.ini)\n"
             "*|All Files"), this,
        i18n("Select Presentation File..."));

  if ( url.isValid() )
  {
    QString file = url.path();
    int pos = file.findRev('/');

    if ( pos != -1 )
    {
      file = file.right( file.length() - pos -1);
    }

    properties->playFilename(file);
    m_general.playFileLE->setText(file);
  } // END if isValid()

} // END slotOpenPlayFile()


void ConfigureDialog::slotOpenDefaultImg()
{
  KURL url = KFileDialog::getOpenURL(properties->base(),
        i18n("*.jpg *.png *.gif|Image Files (*.jpg *.png *.gif)\n"
             "*|All Files"), this,
        i18n("Select Default Image..."));

  if ( url.isValid() )
  {
    QString file = url.path();
    int pos = file.findRev('/');

    if ( pos != -1 )
    {
      file = file.right( file.length() - pos -1);
    }

    properties->defaultImageFilename(file);
    m_general.defaultImgFileLE->setText(file);
  } // END if isValid()

} // END slotOpenDefaultImg()


void ConfigureDialog::slotOpenReportFile()
{
  KURL url = KFileDialog::getOpenURL(properties->base(),
    i18n("*.html *.htm *.HTML *.HTM|HTML File (*.html *.htm *.HTML *.HTM)\n"
         "*|All Files"), this,
    i18n("Select Report File..."));

  if ( url.isValid() )
  {
    QString file = url.path();
    int pos = file.findRev('/');

    if ( pos != -1 )
    {
      file = file.right( file.length() - pos -1);
    }

    properties->reportFilename(file);
    m_general.reportFileLE->setText(file);
  } // END if isValid()

} // END slotOpenReportFile()


void ConfigureDialog::slotOpenBrowser()
{
  KURL url = KFileDialog::getOpenURL(0, 0, this, i18n("Select Browser..."));

  if ( url.isValid() )
  {
    properties->browserName(url.path());
    m_general.browserNameLE->setText(url.path());
  } // END if isValid()

} // END slotOpenBrowser()


void ConfigureDialog::slotOpenBasePath()
{
  KURL url=KFileDialog::getExistingDirectory(m_general.basePathLE->text(),
                            this, i18n("Select base directory..."));

  if ( url.isValid() )
  {
    properties->base(url.path());
    m_general.basePathLE->setText(url.path());
  } // END if isValid()

} // END slotOpenBasePath()
