/***************************************************************************
    soundplayer.h  -  Sound Player
    -------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.11 $
    CVS-ID    : $Id: soundplayer.h,v 1.11 2002/12/16 21:37:17 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SOUNDPLAYER_H
#define SOUNDPLAYER_H


// Qt include files:
#include <qobject.h>

// Application include files:
#include "soundengine.h"

// Forward-Deklarationen:
class QString;


/**
 * SoundPlayer
 *
 * Ein einfacher Sound-Player fuer die Sound-Datei der Praesentation.
 * @see SoundEngine
 *
 * @author Dirk Rosert <dirk@rosert.de>
 * $Revision: 1.11 $
 */
class SoundPlayer : public QObject
{
  Q_OBJECT
  
public: // methods:

  /** Erzeugt einen Sound-Player. */
  SoundPlayer();

  /** */
  ~SoundPlayer();

  /** Oeffnet die Sound-Datei @p filename. */
  void openFile(const QString& filename);

  /** Schliesst die Sound-Datei. */
  void closeFile();

  /** Wird eine Sound-Datei gerade abgespielt ? */
  bool isPlaying() const;

  /** Wurde das Abspielen der Sound-Datei gerade angehalten ? */
  bool isPaused() const;

  /** Ist das Abspielen der Sound-Datei beendet worden ? */
  bool isStopped() const;


public slots:

  /** Beginnt das Ausgeben der Sound-Datei. */
  void play();
  
  /** Unterbricht die Sound-Ausgabe. */
  void pause();
  
  /** Beendet das Abspielen der Sound-Datei. */
  void stop();
  
  /** Spult zur angebenen Position (in msec.) in der Sound-Datei. */
  void seek(int msec);

  /** Gibt die aktuelle Position (in msec.) zurueck. */
  long int getPos();


private: // attributes:

  /** Name der abzuspielenden Sound-Datei. */
  QString      m_filename;

  /** */
  SoundEngine *m_engine;

  /** */
  bool work;

};


#endif // END SOUNDPLAYER_H
