/***************************************************************************
    snapshot.cpp  -  Definiert einen Schnappschuss
    ------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.5 $
    CVS-ID    : $Id: snapshot.cpp,v 1.5 2002/11/10 11:35:47 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Application include files:
#include "ktourpresenter.h"
#include "ktourpresenterdoc.h"
#include "slide.h"
#include "snapshot.h"


Snapshot::Snapshot()
{
  erase();
}


void Snapshot::set(KTourPresenterDoc *doc, int slideIdx, int absTime)
{
  // Um was fuer ein Dia handelt es sich
  Slide slide = doc->slide(slideIdx);

  // berechne die Restzeit fuer das Dia
  int slideAbsTime  = slide.absTime();
  int slideDuration = slide.duration();
  int remainingTime = (slideAbsTime + slideDuration) - absTime;

  m_slideIdx      = slideIdx;
  m_remainingTime = remainingTime;
  m_absTime       = absTime;
}


void Snapshot::erase()
{
  m_slideIdx      = -1;
  m_remainingTime = -1;
  m_absTime       = -1;
}


bool Snapshot::isValid() const
{
  return (m_slideIdx > -1) && (m_remainingTime > -1) && (m_absTime > -1);
}


int Snapshot::slideIdx() const
{
  return m_slideIdx;
}


int Snapshot::remainingTime() const
{
  return m_remainingTime;
}


int Snapshot::absTime() const
{
  return m_absTime;
}
