/***************************************************************************
    slide.cpp  -  Repraesentiert ein Dia in einer Praesentation
    ---------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.12 $
    CVS-ID    : $Id: slide.cpp,v 1.12 2002/11/10 11:35:47 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Qt include files:
#include <qstring.h>

// Application include files:
#include "slide.h"


Slide::Slide(int abstime, int blendingTime, const QString& picfilename,
             int duration, Slide::BlendingTimeSign sign) :
  m_abstime(abstime) ,
  m_blendingTime(blendingTime),
  m_picfilename(picfilename),
  m_duration(duration),
  m_blendingTimeSign(sign)
{
} // END Slide()


int Slide::duration() const
{
  return m_duration;
} // END duration()


int Slide::absTime() const
{
  return m_abstime;
} // END absTime()


Slide::BlendingTimeSign Slide::blendingTimeSign() const
{
  return m_blendingTimeSign;
} // END blendingTimeSign()


int Slide::blendingTime() const
{
  return m_blendingTime;
} // END blendingTime()


int Slide::startTimeOfSlideChange() const
{
  return m_abstime + slideChangeOffset();
} // END startTimeOfSlideChange()


int Slide::endTimeOfSlideChange() const
{
  return startTimeOfSlideChange() + m_duration;
} // END endTimeOfSlideChange()


int Slide::slideChangeOffset() const
{
  // Diawechsel ohne Ueberblendzeit ?
  if ( m_duration == 0 )
    return 0;

  int result;

  switch ( m_blendingTimeSign )
  {
    case Slide::plus:
      result = m_duration/2;
      break;
    case Slide::minus:
      result = -(m_duration/2);
      break;
    default: // none
      result = 0;
  } // END switch

  return result;
} // END SlideChangeffset()


QString Slide::picFilename() const
{
  return m_picfilename;
} // END picFilename()


void Slide::duration(int durationTime)
{
  m_duration = durationTime;
} // END duration()


void Slide::blendingTimeSign(BlendingTimeSign sign)
{
  m_blendingTimeSign = sign;
} // END blendingTimeSign()


void Slide::blendingTime(int value)
{
  m_blendingTime = value;
} // END blendingTime()
