/***************************************************************************
    main.cpp  -  Hauptfunktion von KTourPresenter
    --------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.28 $
    CVS-ID    : $Id: main.cpp,v 1.28 2003/01/19 19:42:23 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// C include files:
#include <stdlib.h>

// STL include files:
#include <iostream>
#include <exception>

// KDE include files:
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

// Application include files:
#include "ktourpresenter.h"
#include "properties.h"


static const char *description = I18N_NOOP(
          "KTourPresenter\n\n"
          
          "A viewer for the presentation of slides of a bycicle tour\n"
          "named \"Pedale Quale\" (http://www.pedale-quale.de). \n\n"
          
          "This software has only beta status yet ! So bug reports\n"
          "are welcomed !\n\n\tHappy Biking !");

static const char* copyright = I18N_NOOP("(c) 2001, 2002 by Dirk Rosert");

static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
};

// sichert globale Einstellungen:
Properties *properties = new Properties();


int main(int argc, char *argv[])
{
  try
  {
    KAboutData aboutData("ktourpresenter", "KTourPresenter",
                         VERSION, description, KAboutData::License_GPL,
                         copyright, 0,
                         "http://www.dirk.rosert.de/ktourpresenter",
                         "dirk@rosert.de");
    aboutData.addAuthor("Dirk Rosert",
                        I18N_NOOP("Maintainer of KTourPresenter."),
                        "dirk@rosert.de",
                        "kttp://www.dirk.rosert.de/ktourpresenter");
    aboutData.addCredit("Stefan Hergarten",
                        I18N_NOOP("For the bug reports to make this piece "
                                  "of software better."),
                        "",
                        "");
    aboutData.addCredit("Carsten Pfeiffer",
                        I18N_NOOP("Some parts depends on KuickShow."),
                        "",
                        "");
    aboutData.addCredit("Noatun-Team",
                        I18N_NOOP("The sound output depends on the "
                                  "KDE media player."),
                        "",
                        "");
    KCmdLineArgs::init(argc, argv, &aboutData);
    KCmdLineArgs::addCmdLineOptions(options);
	  
    KApplication app;
    bool have_top_window = false;

    if ( app.isRestored() )
    {
      int n = 1;
      while ( KTourPresenterApp::canBeRestored(n) )
      {
        KTourPresenterApp *ktourpresenter = new KTourPresenterApp();
        ktourpresenter->restore(n);
        n++;
        have_top_window = true;
      } // END while
    }
    else
    {
      KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
      KTourPresenterApp *ktourpresenter;
      if ( args->count() )
      {
        ktourpresenter = new KTourPresenterApp(args->arg(0));
      }
      else
      {
        ktourpresenter = new KTourPresenterApp();
      } // END if
      ktourpresenter->show();
      have_top_window = true;

      args->clear();
    } // END if isRestored()

    if ( !have_top_window )
    {
      KTourPresenterApp *ktourpresenter = new KTourPresenterApp();
      ktourpresenter->show();
    } // END if !have_top_window

    return app.exec();

  } // try
  catch (exception& e)
  {
    cerr << argv[0] << ": " << e.what() << endl;
    return EXIT_FAILURE;
  } // END catch()
  catch (...)
  {
    cerr << i18n("%1: uncatched exception !").arg(argv[0]) << endl;
    return EXIT_FAILURE;
  } // END catch(...)

  return EXIT_SUCCESS;

} // END main()
