/***************************************************************************
    ktourpresenterview.h  -  Haupt-Widget von KTourPresenter
    --------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.35 $
    CVS-ID    : $Id: ktourpresenterview.h,v 1.35 2002/12/05 09:38:04 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KTOURPRESENTERVIEW_H
#define KTOURPRESENTERVIEW_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL include files:
#include <vector>

// Application include files:
#include "imagewidget.h"
#include "imagefullscreenwidget.h"

// Forward-Deklarationen:
class QLabel;
class QEvent;
class QWheelEvent;
class QWidget;
class KTourPresenterDoc;
class ProgressLine;


/**
 * Die KTourPresenterView-Klasse liefert das Sicht-Widget der
 * KTourPresenterApp-Instanz. Die Sicht-Instanz leitet sich von der
 * Basis-Klasse QWidget ab und repraesentiert das Sicht-Objekt von einem
 * KMainWindow. Da KTourPresenterView Teil des Document-View-Model ist
 * benoetigt es einen Verweis auf das Dokumenten-Objektes, das mit der
 * KTourPresenterApp-Klasse verbunden ist, um die Dokumentenstruktur zu
 * manipulieren und anzuzeigen. Dieses wird durch die KTourPresenterDoc-Klasse
 * geliefert.
 * @see KTourPresenterApp
 * @see KTourPresenterDoc
 * @see ImageWidget
 *
 * @author Dirk Rosert <dirk@rosert.de>
 * $Revision: 1.35 $
 */
class KTourPresenterView : public QWidget
{
  Q_OBJECT
  
public: // types:

  /**
   * Aufzaehlung der Dartstellungsmodi, in dem Arbeitsfenster @p Window
   * oder im Vollbildmodus @p Fullscreen.
   */
  enum ViewMode { Window=0, Fullscreen };


public: // methods:

  /**
   * Erzeugt eine <em>Sicht</em> auf das <em>Dokument</em>.
   * @see KTourPresenterDoc
   */
  KTourPresenterView(QWidget *parent = 0, const char *name=0);
    
  ~KTourPresenterView();

  /**
   * Gibt einen Zeiger auf das Dokument zurueck, das mit diese View-Instanz
   * verbunden ist. Zu beachten ist, dass diese Methode eine
   * KTourPresenterApp-Instanz als Eltern-Widget benoetigt, um mit der
   * KTourPresenterApp::getDocument() Methode an den Zeiger des Dokumentes
   * zu gelangen.
   * @see KTourPresenterApp#getDocument
   */
  KTourPresenterDoc *getDocument() const;

  /** Schaltet 'Auto Hide' des Maus-Cursors der beiden Images ein/aus. */
  void setAutoHideEnabled(bool flag);

  /** */
  bool eventFilter(QObject *o, QEvent *e);

  /** */
  void wheelEvent(QWheelEvent *e);

  /** Das darueberliegende View-Widget wurde in der Groesse veraendert. */
  void resizeEvent(QResizeEvent *e);

  /**
   * Laedt eine Grafik von einem lokalen Laufwerk. Die unterstuetzten
   * Grafikformate sind abhaengig von der Imlib.
   * @see KTourPresenterView#showImage
   */
  void loadImage(const QString& filename);

  /** Laedt eine Grafik in den Cache. */
  bool cacheImage(const QString& filename);

  /**
   * Zeigt das Bild, das sich im Hintergrundspeicher befindet. Anschliessend
   * ist der Hintergrundspeicher bereit um durch ein neues Bild ueberschrieben
 	 * zu werden. Das dargestellte Bild wird skaliert, damit in den
   * Arbeitsbereich (Fenster oder Vollbild) passt.
   * @see KTourPresenterView#loadImage
   */
  void showImage();

  /** Schaltet die Fortschrittsanzeige ein oder aus. */
  void setEnabled(bool);

  /**
   * Setzt den Maximalwert fuer Fortschritts-Slider. Er entspricht der
   * Gesamtzeit der Praesentation in msec.
   */
  void setSliderMax(int maxValue);

  /**
   * Setzt die Gesamtzeit der Praesentation im Format Minuten:Sekunden.
   * Uebergeben wird die Zeit in msec.
   */
  void updateTotalTime(int msec);    

  /**
   * Setzt die aktuelle Praesentationszeit im Format Minuten:Sekunden.
   * Uebergeben wird die Zeit in msec.
   */
  void updateActTime(int msec);

  /** Passt die Slider-Position der uebergebenen Praesentation in msec. an. */
  void updateSlider(int msec);

  /**
   * Liefert den aktuellen Darstellungsmodus.
   * @see KTourPresenterView#ViewMode
   */
  ViewMode viewMode() const;


public slots:

  /**
   * Aufgerufen, wenn der Schieber mit der Maus veraendert wurde. Es muss das
   * passende Dia angezeigt werden.
   */
  void slotNewValue();

  void slotNewValue(int);

  /**
   * Setzte aktuelle und Gesamtzeit auf 00:00 und schalte die
   * Fortschrittszeile aus.
   */
  void slotReset();

  /** Aufgerufen, wenn die Hintergrundfarbe in @p color geaendert wurde. */
  void slotBackgroundColorChanged(const QColor& color);

  /** Helligkeits-, Kontrast- oder Gamma-Wert wurde geaendert. */
  void slotModifierChanged();

  /** Erhoehe Helligkeitswert. */
  void slotMoreBrightness();

  /** Vermindere Helligkeitswert. */
  void slotLessBrightness();

  /** Erhoehe Kontrastwert. */
  void slotMoreContrast();

  /** Vermindere Kontrastwert. */
  void slotLessContrast();

  /** Erhoehe Gamma-Wert. */
  void slotMoreGamma();

  /** Vermindere Gamma-Wert. */
  void slotLessGamma();

  /** Setze die Modifier (Helligkeit, Kontrast und Gamma-Wert) zurueck. */
  void slotResetModifier();

  /** Wechselt zwischen Vollbild- und Anwendungsfenstermodus. */
  void slotToggleFullscreen();

  /**
   * Wird aufgerufen, wenn der Mausszeiger aus- oder wieder eingeschaltet
   * werden soll.
   */
  void slotHideMouseChanged(bool);


signals:
  
  /**
   * Emittiert, wenn die Schieber-Position durch die Mouse veraendert wurde.
   */
  void sigNewSliderPos(int);

  /**
   * Signalisiert, dass das naechste Dia angezeigt werden soll (z.B.
   * hervorgerufen durch Mausrad).
   */
  void sigNext();

  /**
   * Signalisiert, dass das vorherige Dia angezeigt werden soll (z.B.
   * hervorgerufen durch Mausrad).
   */
  void sigPrev();


protected: // attributes:

  /** Aktueller Darstellungsmodus. */
  ViewMode currMode;


private: // attributes:

  // Das Widget zur Darstellung der Dias
  ImageWidget *m_image;

  // Fortschrittsanzeige
  ProgressLine *progress;

  // Name des aktuellen Dias
  QString currImageFilename;

};


#endif // KTOURPRESENTERVIEW_H
