/***************************************************************************
    imagefullscreenwidget.cpp  -  Ein ImageWidget im Vollbildmodus
    -------------------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.8 $
    CVS-ID    : $Id: imagefullscreenwidget.cpp,v 1.8 2002/12/16 22:13:42 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL include files:
#include <iostream>

// KDE include files:
#include <kapplication.h>  // for kapp
#include <kwin.h>

// Application include files:
#include "imagefullscreenwidget.h"
#include "ktourpresenter.h"
#include "ktourpresenterdoc.h"
#include "ktourpresenterview.h"
#include "slide.h"


static const int wflags = Qt::WType_TopLevel    |
                          Qt::WStyle_Customize  |
                          Qt::WStyle_StaysOnTop |
                          Qt::WStyle_NoBorder;

ImageFullscreenWidget::ImageFullscreenWidget(ImageWidget *parent,
                                             const char *name) :
  ImageWidget(name, parent, wflags)
{
  setGeometry(kapp->desktop()->geometry());
  setFixedSize(kapp->desktop()->size());

  m_width  = kapp->desktop()->geometry().width();
  m_height = kapp->desktop()->geometry().height();

} // END ImageFullscreenWidget()


ImageFullscreenWidget::~ImageFullscreenWidget()
{
} // END ImageFullscreenWidget()


void ImageFullscreenWidget::resizeEvent(QResizeEvent *)
{
  setGeometry(kapp->desktop()->geometry());
} // END resizeEvent()
