/***************************************************************************
    configuredialog.cpp  -  Konfigurations-Dialog von KTourPresenter
    -------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.44 $
    CVS-ID    : $Id: configuredialog.cpp,v 1.44 2002/11/08 15:34:36 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// STL include files:
#include <iostream>

// Qt include files:
#include <qlayout.h>
#include <qlineedit.h>

// KDE include files:
#include <kedittoolbar.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kurl.h>

// Application include files:
#include "configuredialog.h"
#include "imagewidget.h"
#include "properties.h"


// erzeugt in main.cpp:
extern Properties *properties;


ConfigureDialog::ConfigureDialog(QWidget *parent, const char *name,
                                 KAccel *accel, KMainWindow *toplevel,
                                 bool modal)
:   KDialogBase(IconList, i18n("Configure"), Default|Apply|Ok|Cancel, Ok,
                parent, name, modal, true),
  m_accel(accel),
  m_toplevel(toplevel),
  m_oldBrightness(properties->brightness()),
  m_oldContrast(properties->contrast()),
  m_oldGamma(properties->gamma()),
  m_toolbarDirty(false)

{
  // baue die einzelnen Seiten auf:
  setupGeneralPage();        // siehe cfg_general.cpp
  setupPresentationPage();   // siehe cfg_presentation.cpp
  setupImagePage();          // siehe cfg_image.cpp
  setupToolbarPage();

} // END ConfigureDialog()


ConfigureDialog::~ConfigureDialog()
{
} // END ~ConfigureDialog()


void ConfigureDialog::setValues()
{
  setValuesGeneral();
  setValuesPresentation();
  setValuesImage();
} // END setValues();


void ConfigureDialog::setupToolbarPage()
{
  QFrame *page =
    addPage(i18n("Toolbar"), i18n("Configuration of the Toolbar"),
            BarIcon("wizard", KIcon::SizeMedium));

  // *** Widgets ***
  m_toolbar.edit = new KEditToolbarWidget(m_toplevel->factory(), page);

  // *** Connect ***
  connect(m_toolbar.edit, SIGNAL(enableOk(bool)),
          this,          SLOT(slotToolbarDirty(bool)));

  // *** Layout ***
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());
  topLayout->addWidget(m_toolbar.edit);

} // END setupToolbar()


void ConfigureDialog::slotOk()
{
  slotApply();
  accept();
} // END slotOK()


void ConfigureDialog::slotApply()
{
  applyGeneral();
  applyPresentation();
  applyImage();

  // Toolbar:
  if ( m_toolbarDirty )
  {
    m_toolbar.edit->save();
    emit sigToolbarChanged();
  } // END if

} // END slotApply()


void ConfigureDialog::slotDefault()
{
  // setze Werte zurueck:
  properties->defaultValues();

  // Passe dementsprechend die Dialog-Elemente an:
  setValues();
} // END slotDefault()


void ConfigureDialog::slotToolbarDirty(bool flag)
{
  if ( flag )
    m_toolbarDirty = true;

} // END slotToolbarDirty()
