/***************************************************************************
    cfg_presentation.cpp  -  Konfiguration der Praesentation
    --------------------
    copyright : (C) 2002 by Dirk Rosert
    email     : dirk@rosert.de
    author    : $Author: dirk $
    revision  : $Revision: 1.3 $
    CVS-ID    : $Id: cfg_presentation.cpp,v 1.3 2002/12/03 14:33:12 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Qt include files:
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qwhatsthis.h>

// KDE include files:
#include <kcolorbtn.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <knuminput.h>

// Application include files:
#include "configuredialog.h"
#include "properties.h"


// erzeugt in main.cpp:
extern Properties *properties;


void ConfigureDialog::setupPresentationPage()
{
  QFrame *page = addPage( i18n("Presentation"), i18n("Presentation Settings"),
                          BarIcon("queue", KIcon::SizeMedium) );
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());


  // <<< Groupe box: file and directory names >>>
  QGroupBox *generalGroup;
  generalGroup = new QGroupBox(page, "generalgroup");
  generalGroup->setTitle(i18n("General"));

  //
  QGridLayout *gridLayout =
    new QGridLayout(generalGroup, 8, 2, 20, 10, "generalgroup");

  QLabel *autoLoadLabel =
    new QLabel(i18n("Automatic loading of the presentation on startup"),
               generalGroup, "autoLoadLabel");
  m_presentation.autoLoadCB = new QCheckBox(" ", generalGroup, "autoloadcb");
  m_presentation.autoLoadCB->setChecked(properties->autoLoad());
  gridLayout->addWidget(autoLoadLabel,             0, 0);
  gridLayout->addWidget(m_presentation.autoLoadCB, 0, 1, AlignCenter);

  QLabel *autoStartLabel =
    new QLabel(i18n("Automatic starting of a loaded presentation"),
               generalGroup, "autoStartLabel");
  m_presentation.autoStartCB = new QCheckBox(" ", generalGroup, "autostartcb");
  m_presentation.autoStartCB->setChecked(properties->autoStart());
  gridLayout->addWidget(autoStartLabel,             1, 0);
  gridLayout->addWidget(m_presentation.autoStartCB, 1, 1, AlignCenter);

  QLabel *autoQuitLabel =
    new QLabel(i18n("Automatic quit application after presentation"),
               generalGroup, "autoQuitLabel");
  m_presentation.autoQuitCB = new QCheckBox(" ", generalGroup, "autoquitcb");
  m_presentation.autoQuitCB->setChecked(properties->autoQuit());
  gridLayout->addWidget(autoQuitLabel,             2, 0);
  gridLayout->addWidget(m_presentation.autoQuitCB, 2, 1, AlignCenter);

  QLabel *autoFullscreenLabel =
    new QLabel(i18n("Start presentation in fullscreen"),
               generalGroup, "autoFullscreenLabel");
  m_presentation.fullscreenCB =
    new QCheckBox(" ", generalGroup, "fullscreencb");
  m_presentation.fullscreenCB->setChecked(properties->fullscreen());
  gridLayout->addWidget(autoFullscreenLabel,         3, 0);
  gridLayout->addWidget(m_presentation.fullscreenCB, 3, 1, AlignCenter);

  // Bildschrimschoner ausschalten
  QLabel *disableSSaverLB =
    new QLabel(i18n("Disable screen saver during the presentation"),
               generalGroup, "disablessaverlabel");
  m_presentation.disableSSaverCB =
    new QCheckBox(" ", generalGroup, "disablessavercb");
  m_presentation.disableSSaverCB->setChecked(
                                    properties->disableScreensaver());
  connect(m_presentation.disableSSaverCB, SIGNAL(toggled(bool)),
                             SLOT(slotScreenSaverWarning(bool)));
  gridLayout->addWidget(disableSSaverLB,                4, 0);
  gridLayout->addWidget(m_presentation.disableSSaverCB, 4, 1, AlignCenter);

  // Mauszeiger ausblenden
  QLabel *hideMouseLabel =
    new QLabel(i18n("Hide Mouse Cursor"), generalGroup, "hidemouselabel");
  m_presentation.hideMouseCB =
    new QCheckBox(" ", generalGroup, "hidemousecb");
  m_presentation.hideMouseCB->setChecked(properties->hideMouse());
  connect(m_presentation.hideMouseCB, SIGNAL(toggled(bool)),
                             SLOT(slotHideMouseToggled(bool)));
  gridLayout->addWidget(hideMouseLabel,             5, 0);
  gridLayout->addWidget(m_presentation.hideMouseCB, 5, 1, AlignCenter);
  QString hideTT =
    i18n("Sets auto-hiding the mouse cursor. The cursor will be shown again "
         "when you move the cursor.");
  QWhatsThis::add(hideMouseLabel,             hideTT);
  QWhatsThis::add(m_presentation.hideMouseCB, hideTT);

  // Verzoegerungszeit
  m_presentation.hideDelayNUM = new KIntNumInput(generalGroup, "hidedelay");
  m_presentation.hideDelayNUM->setLabel(i18n("Delay Time (sec.): "),
                                   AlignVCenter);
  m_presentation.hideDelayNUM->setRange(1, 10, 1);
  m_presentation.hideDelayNUM->setValue(properties->hideDelay() / 1000);
  gridLayout->addWidget(m_presentation.hideDelayNUM, 6, 0);
  if ( !m_presentation.hideMouseCB->isChecked() )
    m_presentation.hideDelayNUM->setEnabled(false);
  QString delayTT =
    i18n("Sets the delay time in seconds for auto-hiding the mouse cursor.");
  QWhatsThis::add(m_presentation.hideDelayNUM, delayTT);

  // Hintergrundfarbe
  QLabel *backgroundLabel =
    new QLabel(i18n("Background Color"), generalGroup, "backgroundlabel");
  m_presentation.backgroundButton = new KColorButton(generalGroup);
  m_presentation.backgroundButton->setColor(properties->backgroundColor());
  gridLayout->addWidget(backgroundLabel,                 7, 0);
  gridLayout->addWidget(m_presentation.backgroundButton, 7, 1, AlignCenter);
  m_presentation.backgroundButton->setFixedWidth(
                    2 * m_presentation.backgroundButton->height());

  // Layout:
  topLayout->addWidget(generalGroup);
  topLayout->addStretch(1);

} // END setupPresentationPage()


void ConfigureDialog::setValuesPresentation()
{
  m_presentation.autoLoadCB->setChecked(properties->autoLoad());
  m_presentation.autoStartCB->setChecked(properties->autoStart());
  m_presentation.fullscreenCB->setChecked(properties->fullscreen());
  m_presentation.backgroundButton->setColor(properties->backgroundColor());
  m_presentation.hideMouseCB->setChecked(properties->hideMouse());
  m_presentation.hideDelayNUM->setValue(properties->hideDelay()/1000);
  m_presentation.disableSSaverCB->setChecked(
                                         properties->disableScreensaver());
} // END setValuesPresentation()


void ConfigureDialog::applyPresentation()
{
  properties->autoLoad(m_presentation.autoLoadCB->isChecked());
  properties->autoStart(m_presentation.autoStartCB->isChecked());
  properties->autoQuit(m_presentation.autoQuitCB->isChecked());
  properties->fullscreen(m_presentation.fullscreenCB->isChecked());
  bool ssaverValue = m_presentation.disableSSaverCB->isChecked();

  if ( ssaverValue != properties->disableScreensaver() )
  {
    properties->disableScreensaver(ssaverValue);
    emit sigDisableScreensaver(ssaverValue);
  } // END if

  bool hideMouseFlag = m_presentation.hideMouseCB->isChecked();
  if ( properties->hideMouse() != hideMouseFlag )
  {
    properties->hideMouse(hideMouseFlag);
    emit sigHideMouseChanged(hideMouseFlag);
  } // END if

  properties->hideDelay(m_presentation.hideDelayNUM->value()*1000);

  QColor newColor = m_presentation.backgroundButton->color();
  if ( properties->backgroundColor() != newColor )
  {
    properties->backgroundColor(newColor);
    emit sigBackgroundColorChanged(newColor);
  } // END if

} // END applyPresentation()


void ConfigureDialog::slotScreenSaverWarning(bool flag)
{
  if ( flag )
  {
    bool screenSaverFlag = properties->screenSaverWarning();
    QString text = i18n("This is an experimental function in a KDE "
                        "environment. In some cases a disabled screensaver "
                        "can not be restored after a presentation. If you "
                        "decide to disable the screensaver you might enable "
                        "it with the KDE Control Center.");
    QString caption   = i18n("Warning: Disable Screensaver");
    QString yesButton = i18n("Disable Screensver");

    QString dontAskAgainName = "Confirm Disable Screensaver Warning";
    if ( ( !screenSaverFlag ) ||
         ( screenSaverFlag &&
           KMessageBox::warningYesNo(0, text, caption, yesButton,
                             KStdGuiItem::discard(), dontAskAgainName)
                        != KMessageBox::Yes )
       )
    {
      // ... dann nicht, stelle alten Zustand wieder her:
      m_presentation.disableSSaverCB->setChecked(false);
      properties->disableScreensaver(false);
    } // END if

  } // END if flag

} // END slotScreenSaverWarning();


void ConfigureDialog::slotHideMouseToggled(bool flag)
{
  m_presentation.hideDelayNUM->setEnabled(flag);
} // END slotHideMouseToggled()
