/***************************************************************************
    soundplayer.h  -  Sound Player
    -------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.7 $
    CVS-ID    : $Id: soundplayer.h,v 1.7 2002/02/02 19:23:52 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SOUNDPLAYER_H
#define SOUNDPLAYER_H


// STL include files:
#include <string>

// Qt include files:
#include <qobject.h>
#include <qstring.h>

// Application include files:
#include "soundengine.h"


/**
 * SoundPlayer
 *
 * Ein einfacher Sound-Player fuer die Sound-Datei der Praesentation.
 * @see SoundEngine
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.7 $
 */
class SoundPlayer : public QObject
{
  Q_OBJECT
  
public: // methods:

  /** Erzeugt einen Sound-Player. */
  SoundPlayer();

  /** */
  ~SoundPlayer();

  /** Oeffnet die Sound-Datei @p filename. */
  void openFile(const QString& filename);

  /** Schliesst die Sound-Datei. */
  void closeFile();

  /** Wird eine Sound-Datei gerade abgespielt ? */
  bool isPlaying() const;

  /** Wurde das Abspielen der Sound-Datei gerade angehalten ? */
  bool isPaused() const;

  /** Ist das Abspielen der Sound-Datei beendet worden ? */
  bool isStopped() const;


public slots:

  /** Beginnt das Ausgeben der Sound-Datei. */
  void play();
  
  /** Unterbricht die Sound-Ausgabe. */
  void pause();
  
  /** Beendet das Abspielen der Sound-Datei. */
  void stop();
  
  /** Spult zur angebenen Position (in msec.) in der Sound-Datei. */
  void seek(int msec);

  /** Gibt die aktuelle Position (in msec.) zurueck. */
  long int getPos();


private: // attributes:

  /// Name der abzuspielenden Sound-Datei:
  QString      m_filename;

  ///
  SoundEngine *m_engine;

};


#endif // END SOUNDPLAYER_H
