/***************************************************************************
    soundplayer.cpp  -  Sound Player
    ---------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.8 $
    CVS-ID    : $Id: soundplayer.cpp,v 1.8 2002/02/02 19:23:52 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// STL include files:
#include <iostream>

// Application include files:
#include "soundplayer.h"


enum ArtsPOS { posIdle=0, posPlaying, posPaused };


SoundPlayer::SoundPlayer()
{
  m_engine = new SoundEngine;
} // END SoundPlayer()


SoundPlayer::~SoundPlayer()
{
  if ( m_engine != 0 )
    delete m_engine;
} // END ~SoundPlayer()


void SoundPlayer::openFile(const QString& filename)
{
  m_filename = filename;
} // END openFile()


void SoundPlayer::closeFile()
{
  if ( m_engine != 0 )
  {
    stop();
  } // END if
} // END closeFile()


bool SoundPlayer::isPlaying() const
{
  return (m_engine == 0) ? false : (m_engine->state() == posPlaying);
} // END isPlaying()


bool SoundPlayer::isPaused() const
{
  return (m_engine == 0) ? false : (m_engine->state() == posPaused);
} // END isPaused()


bool SoundPlayer::isStopped() const
{
  return (m_engine == 0) ? false : (m_engine->state() == posIdle);
} // END isStopped()

  
void SoundPlayer::play()
{
  if ( m_engine == 0)
    return;

  bool work = false;
  
  if ( m_engine->state() == posPaused )
  {
    work = m_engine->play();
  }
  else
  {
    stop();
    work = m_engine->open(m_filename);

    if ( work )
      work = m_engine->play();
  } // END if

} // END play()


void SoundPlayer::pause()
{
  if ( m_engine == 0)
    return;

  if ( m_engine->state() == posPlaying )
    m_engine->pause();
  else
    m_engine->play();

} // END pause()


void SoundPlayer::stop()
{
  if ( m_engine == 0)
    return;

  m_engine->stop();
} // END stop()


void SoundPlayer::seek(int msec)
{
  if ( m_engine == 0)
    return;

  m_engine->seek(msec);
} // END seek()


long int SoundPlayer::getPos()
{
  if ( m_engine == 0)
    return -1;

  return m_engine->currentTime();
} // END getPos()
