/***************************************************************************
    snapshot.h  -  Definiert einen Schnappschuss
    ----------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.3 $
    CVS-ID    : $Id: snapshot.h,v 1.3 2002/01/01 18:28:25 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SNAPSHOT_H
#define SNAPSHOT_H


// Forward-Deklarationen:
class KTourPresenterApp;
class KTourPresenterDoc;


/**
 * Klasse Snapshot
 *
 * Definiert einen Schnappschuss, der ausgeloest wird, wenn eine Praesentation
 * (durch 'Pause') unterbrochen wird. Die Informationen werden benoetigt, um
 * das Abspielen der Praesentation wieder aufnehmen (durch 'Play' oder
 * wiederholtem 'Pause') zu koennen.
 * @see KTourPresenterApp
 * @see KTourPresenterDoc
 * @see Slide
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.3 $
 */

class Snapshot
{
  friend class KTourPresenterApp;

public: 

  /**
   * Erzeugt einen (erstmal ungueltigen) Schnappschuss. Erst durch
   * set() wird dieser gueltig.
   */
  Snapshot();

  /**
   * Macht diesen Schnappschuss gueltig. Es wird ein Schnappschuss fuer das
   * Dia mit dem Index @p slideIdx zur Zeit @p absTime (in msec.) gesetzt.
   * Dieses Dia ist Teil des Dokumentes @p doc.
   */
  void set(KTourPresenterDoc *doc, int slideIdx, int absTime);

  /** Macht diesen Schnappschuss unglueltig. */
  void erase();

  /** Ist dieser Schnappschuss ein gueltiger Schnappschuss ? */
  bool isValid() const;

  /**
   * Gibt den Index des Dias dieses Schnappschusses zurueck. Der Index
   * entspricht der Position im (aktuellen) Ablaufplan.
   */
  int slideIdx() const;

  /** Gibt die Restzeit zurueck, die dieses Dia noch gezeigt werden muss. */
  int remainingTime() const;

  /**
   * Gibt die absolute Zeit seit Praesentationsbeginn zurueck, in der dieser
   * Schnappschuss gesetzt wurde.
   */
  int absTime() const;


private:

  /** */
  int m_slideIdx;

  /** */
  int m_remainingTime;

  /** */
  int m_absTime;

};


#endif // END SNAPSHOT_H
