/***************************************************************************
    properties.h  -  Eigenschaften der Anwendung
    ------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.20 $
    CVS-ID    : $Id: properties.h,v 1.20 2002/02/14 11:01:25 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef PROPERTIES_H
#define PROPERTIES_H


// Qt include files:
#include <qstring.h>
#include <qsize.h>
#include <qcolor.h>


// Forward-Deklarationen:
class ImData;


/**
 * Properties
 *
 * Eine Klasse die global zugreifbare Eigenschaften repraesentiert. Welche
 * Eigenschaften verwaltet werden ist den Namen der Objekt-Methoden zu
 * entnehmen.
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.20 $
 */
class Properties
{
public:

  /**
   * Konstruktor
   *
   * Erzeugt ein Properties-Objekt mit den folgenden Standard-Werten:
   * <ul>
   *   <li>startupLogo = <tt>true</tt>
   *   <li>base = <tt>/cdrom/</tt>
   *   <li>playFilename = <tt>play.ini</tt>
   *   <li>fullscreen = <tt>false</tt>
   *   <li>defaultImageFilename = <tt>default.jpg</tt>
   *   <li>reportFilename = <tt>bericht.htm</tt>
   *   <li>reportBrowserSize = <tt>320</tt>x<tt>240</tt>
   *   <li>autoLoad = <tt>true</tt>
   *   <li>autoStart = <tt>false</tt>
   *   <li>autoQuit = <tt>false</tt>
   *   <li>browserName = <tt>konqueror</tt>
   *   <li>...
   * </ul>
   */
  Properties();

  /** */
  ~Properties();

  /** Soll beim Starten das Startup-Logo angezeigt werden ? */
  bool startupLogo() const;

  /** Soll beim Beenden der Anwendung nochmal nachgefragt werden ?*/
  bool confirmExit() const;

  /** Basis-Verzeichnis der Praesentation (z.B. /cdrom/). */
  QString base() const;

  /** Name der Abspieldatei (z.B. play.ini). */
  QString playFilename() const;

  /** Soll die Praesentation im Vollbildmodus abgespielt werden ? */
  bool fullscreen() const
  {
    return m_fullscreen;
  }

  /** Soll Bildschirmschoner ausgeschaltet werden ?*/
  bool disableScreensaver() const;

  /** Dateiname der Default-Grafik (z.B. default.jpg). */
  QString defaultImageFilename() const;

  /** Name der Sound-Datei (z.B. sound.wav). */
  QString soundFilename() const;

  /** Name des Tourberichtes (z.B. bericht.htm). */
  QString reportFilename() const;

  /**
   * Soll die Praesentation ( Dateiname base()+playFilename() ) beim
   * Programmstart automatisch geladen werden ?
   */
  bool autoLoad() const;

  /** Soll die geladene Praesentation automatisch abgespielt werden. */
  bool autoStart() const;

  /**
   * Soll das Programm am Ende der Praesentation automatisch beendet werden ?
   */
  bool autoQuit() const;

  /**
   * Gibt den Namen des Browsers zurueck (z.B. konqueror).
   */
  QString browserName() const;

  /** Gibt die Hintergrundfarbe fuer die Dias zurueck. */
  QColor backgroundColor() const;

  /**
   * Soll der Mauszeiger nach 3 Sekunden <em>Regungslosigkeit</em> beim
   * Abspielen der Praesentation versteckt werden ?
   */
  bool hideMouse() const;

  /** */
  int hideDelay() const;

  /**
   * Gibt den Gamma-Faktor (zwischen -256 und 256) fuer die Imlib-Grafiken
   * zurueck.
   */
  inline int gamma() const
  {
    return m_gamma;
  }

  /**
   * Gibt den Helligkeitswert (zwischen -256 und 256) fuer die Imlib-Grafiken
   * zurueck.
   */
  inline int brightness() const
  {
    return m_brightness;
  }

  /**
   * Gibt den Kontrastwert (zwischen -256 und 256) fuer die Imlib-Grafiken
   * zurueck.
   */
  inline int contrast() const
  {
    return m_contrast;
  }

  /** */
  inline bool ownPalette() const
  {
    return m_ownPalette;
  }

  /** */
  inline bool fastRemap() const
  {
    return m_fastRemap;
  }

  /** */
  inline bool fastRender() const
  {
    return m_fastRender;
  }

  /** Soll Dithering auch fuer 16-Bit-Darstellung benutzt werden ? */
  inline bool dither16bit() const
  {
    return m_dither16bit;
  }

  /** Soll Dithering auch fuer 8-Bit-Darstellung benutzt werden ? */
  inline bool dither8bit() const
  {
    return m_dither8bit;
  }

  /** */
  inline unsigned int gammaFactor() const
  {
    return m_gammaFactor;
  }

  /** */
  unsigned int brightnessFactor() const
  {
    return m_brightnessFactor;
  }

  /** */
  inline unsigned int contrastFactor() const
  {
    return m_contrastFactor;
  }

  /** Gibt die Maximale Groesse des Imlib-Caches zurueck. */
  unsigned int maxCache() const;

  /**
   * Gibt die Schrittweite fuer die Helligkeitsveraenderung zurueck, die
   * ueber Accelatoren getaetigt wird.
   */
  inline int brightnessSteps() const
  {
    return m_brightnessSteps;
  }

  /**
   * Gibt die Schrittweite fuer die Kontrastveraenderung zurueck, die
   * ueber Accelatoren getaetigt wird.
   */
  inline int contrastSteps() const
  {
    return m_contrastSteps;
  }

  /**
   * Gibt die Schrittweite fuer die Gammaveraenderung zurueck, die
   * ueber Accelatoren getaetigt wird.
   */
  inline int gammaSteps() const
  {
    return m_gammaSteps;
  }

  /** Gibt die maximal Breite einer Grafik zurueck. */
  unsigned int maxWidth() const;

  /** Gibt die maximal Hoehe einer Grafik zurueck. */
  unsigned int maxHeight() const;

  /** Sind Image-Modifikationen erlaubt ? */
  inline bool isModsEnabled() const
  {
    return m_isModsEnabled;
  }

  /** Ist das Verkleinernern erlaubt ? */
  inline bool downScale() const
  {
    return m_downScale;
  }

  /** Ist das Vergroessern erlaubt ? */
  inline bool upScale() const
  {
    return m_upScale;
  }

  /** Gibt den ganzzahligen Faktor bis zu dem Vergroessern erlaubt ist. */
  inline int maxUpScale() const
  {
    return m_maxUpScale;
  }


  /** Legt fest, ob beim Programmstart das Logo gezeigt werden soll. */
  void startupLogo(bool flag);

  /** Legt fest, ob beim Beenden der Anwendung nachgefragt werden soll. */
  void confirmExit(bool flag);

  /** Setzt das Basisverzeichnis der Praesentation. */
  void base(const QString& base);

  /** Setzt den Dateinamen der Abspieldatei. */
  void playFilename(const QString& filename);

  /** Legt fest, ob der Vollbildmodus benutzt werden soll. */
  void fullscreen(bool fullscreen);

  /** Legt fest, ob der Bildschirmschoner ausgeschaltet werden soll. */
  void disableScreensaver(bool flag);

  /**
   * Setzt den Dateinamen der Default-Grafik, der vor dem Starten der
   * Praesentation gestartet werden soll.
   */
  void defaultImageFilename(const QString& filename);

  /** Setzt den Namen der Sound-Datei. */
  void soundFilename(const QString& filename);

  /** Setzt den Namen des Tourberichtes. */
  void reportFilename(const QString& filename);

  /**
   * Soll beim Programmstart die Praesentation automatisch geladen werden ?
   */
  void autoLoad(bool);

  /** Soll die geladene Praesentation automatisch gestartet werden ? */
  void autoStart(bool);

  /**
   * Soll das Programm am Ende der Praesentation automatisch beendet werden ?
   */
  void autoQuit(bool);

  /** Setzt den Namen fuer den externen Browser. */
  void browserName(const QString& name);

  /** Setzt die Hintergrundfarbe. */
  void backgroundColor(const QColor& color);

  /** */
  void hideMouse(bool flag);

  /** */
  void hideDelay(int delay);

  /** Setzt den Gamma-Wert fuer die Bilder. */
  void gamma(int gamma);

  /** Setzt den Helligkeitswert fuer die Bilder. */
  void brightness(int brightness);

  /** Setzt den Kontrastwert fuer die Bilder. */
  void contrast(int contrast);

  /** Soll (bei 8Bit-Darstellung) eine eigene Farbpalette benutzt werden ? */
  void ownPalette(bool flag);

  /** */
  void fastRemap(bool flag);

  /** */
  void fastRender(bool flag);

  /** Soll bei 8Bit-Darstellung <em>gedithert</em> werden ? */
  void dither16bit(bool flag);

  /** Soll bei 16Bit-Darstellung <em>gedithert</em> werden ? */
  void dither8bit(bool flag);

  /** */
  void gammaFactor(unsigned int factor);

  /** */
  void brightnessFactor(unsigned int factor);

  /** */
  void contrastFactor(unsigned int factor);

  /** Setzt die maximale Cache-Groesse (in KB). */
  void maxCache(unsigned int maxcache);

  /** Duerfen Bilder verkleinert werden ? */
  void downScale(bool);

  /** Duerfen Bilder vergroessert werden ? */
  void upScale(bool);

  /** Bis zu welchem Vergroesserungsfaktor darf vergroessert werden. */
  void maxUpScale(int);

  /** Setzt die Eigenschaften auf Standard-Werte. */
  void defaultValues();


private: // attributes:

  bool         m_startupLogo;
  bool         m_confirmExit;
  QString      m_base;
  QString      m_playFilename;
  bool         m_fullscreen;
  bool         m_disableScreensaver;
  QString      m_defaultImageFilename;
  QString      m_soundFilename;
  QString      m_reportFilename;
  bool         m_autoLoad;
  bool         m_autoStart;
  bool         m_autoQuit;
  QString      m_browserName;
  QColor       m_backgroundColor;
  bool         m_hideMouse;
  int          m_hideDelay;

  int          m_gamma;
  int          m_brightness;
  int          m_contrast;
  int          m_gammaSteps;
  int          m_brightnessSteps;
  int          m_contrastSteps;
  unsigned int m_gammaFactor;
  unsigned int m_brightnessFactor;
  unsigned int m_contrastFactor;
  bool         m_ownPalette;
  bool         m_fastRemap;
  bool         m_fastRender;
  bool         m_dither16bit;
  bool         m_dither8bit;
  unsigned int m_maxCache;
  int          m_scrollSteps;
  float        m_zoomSteps;
  unsigned int m_maxWidth;
  unsigned int m_maxHeight;
  bool         m_isModsEnabled;
  bool         m_downScale;
  bool         m_upScale;
  int          m_maxUpScale;

};


#endif // END PROPERTIES_H
