/***************************************************************************
    main.cpp  -  Hauptfunktion von KTourPresenter
    --------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.16 $
    CVS-ID    : $Id: main.cpp,v 1.16 2002/02/01 19:54:00 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// C include files:
#include <stdlib.h>

// STL include files:
#include <iostream>
#include <exception>

// KDE include files:
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

// Application include files:
#include "ktourpresenter.h"
#include "properties.h"


static const char *description =
          I18N_NOOP("KTourPresenter\n\n" \

          "A viewer for the presentation of slides of a bycicle tour\n" \
          "named \"Pedale Quale\" (http://www.pedale-quale.de). \n\n"

          "This software has only beta status yet ! So bug reports\n"
          "are welcomed !");
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
};

// sichert globale Einstellungen:
Properties *properties = new Properties();


int main(int argc, char *argv[])
{
  try
  {
    KAboutData aboutData("ktourpresenter", I18N_NOOP("KTourPresenter"),
                         VERSION, description, KAboutData::License_GPL,
                         I18N_NOOP("(c) 2001, 2002 by Dirk Rosert"), 0, 0,
                         "dirk@kiste.ping.de");
    aboutData.addAuthor("Dirk Rosert",
                        I18N_NOOP("Maintainer of KTourPresenter."),
                        "dirk@kiste.ping.de",
                        "");
    aboutData.addCredit("Carsten Pfeiffer",
                        I18N_NOOP("Some parts depends on KuickShow."),
                        "",
                        "");
    aboutData.addCredit("Noatun-Team",
                        I18N_NOOP("The sound output depends on the "
                                  "KDE media player."),
                        "",
                        "");
    KCmdLineArgs::init(argc, argv, &aboutData);
    KCmdLineArgs::addCmdLineOptions(options);
	  
    KApplication app;
    bool have_top_window = false;

    if ( app.isRestored() )
    {
      int n = 1;
      while ( KTourPresenterApp::canBeRestored(n) )
      {
        KTourPresenterApp *ktourpresenter = new KTourPresenterApp();
        ktourpresenter->restore(n);
        n++;
        have_top_window = true;
      } // END while
    }
    else
    {
      KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
      KTourPresenterApp *ktourpresenter;
      if ( args->count() )
      {
        ktourpresenter = new KTourPresenterApp(args->arg(0));
      }
      else
      {
        ktourpresenter = new KTourPresenterApp();
      } // END if
      ktourpresenter->show();
      have_top_window = true;

      args->clear();
    } // END if isRestored()

    if ( !have_top_window )
    {
      KTourPresenterApp *ktourpresenter = new KTourPresenterApp();
      ktourpresenter->show();
    } // END if !have_top_window

    return app.exec();

  } // try
  catch (...)
  {
    cerr << i18n("%1: uncatched exception !").arg(argv[0]) << endl;
  } // END catch(...)
  
  return EXIT_FAILURE;
}  
