/***************************************************************************
    ktourpresenterdoc.h  -  Dokumentenobjekt von KTourPresenter
    -------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.18 $
    CVS-ID    : $Id: ktourpresenterdoc.h,v 1.18 2002/02/04 11:50:28 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KTOURPRESENTERDOC_H
#define KTOURPRESENTERDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 


// C include files:
#include <stdio.h>

// STL include files:
#include <vector>

// Qt include files:
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qstrlist.h>

#ifdef index
#undef index
#endif

#ifdef KeyPress
#undef KeyPress
#endif

// KDE include files:
#include <kurl.h>

// Application include files:
#include "schedule.h"
#include "slide.h"


// Forward-Deklarationen:
class KTourPresenterView;


/**
 * KTourPresenterDoc stellt ein Dokumenten-Objekt zur Verfuegung, das in
 * Verbindung mit den Klassen KTourPresenterApp und KTourPresenterView
 * benutzt wird, um das <em>Document View Model</em> fuer
 * KDE-Standardanwendungen, basierend auf KApplication und KMainWindow, zu
 * erzeugen. Dabei wird das Dokumenten-Objekt durch die
 * KTourPresenterApp-Instanz erzeugt und enthaelt die Dokumentenstruktur mit
 * den zugehoerigen Methoden zur Manipulation der Dokumenten-Daten durch das
 * KTourPresenter-Objekt.
 * @see KTourPresenterApp
 * @see KTourPresenterView
 * @see Schedule
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.18 $
 */
class KTourPresenterDoc : public QObject
{
  Q_OBJECT
  
public:

  /** Konstruktor */
  KTourPresenterDoc(QWidget *parent, const char *name=0);
    
  /** Destruktor */
  ~KTourPresenterDoc();

  /**
   * Fuegt ein View zu diesem Dokument hinzu, das den Dokumenteninhalt
   * repraesentiert. Dies ist normalerweise die Hauptansicht.
   */
  void addView(KTourPresenterView *view);
    
  /** Entfernt eine View von der Liste der altuell angebundenen Views. */
  void removeView(KTourPresenterView *view);
    
  /** Loescht den Inhalt des Dokumentes. */
  void deleteContents();
    
  /** Initialisiert das Dokument. */
  bool newDocument();
    
  /** Schliesst das aktuelle Dokument. */
  void closeDocument();
    
  /**
   * Laedt das Dokument mittels @p filename und emittiert das
   * <tt>updateViews()</tt>-Signal. Konnte die Datei geladen werden, dann
   * wird <tt>true</tt> zurueckgegeben, anderfalls <tt>false</tt>.
   */
  bool openDocument(const KURL& url);

  /** Gibt die URL des Dokumentes zurueck. */
  const KURL& URL() const;
    
  /** Setzt die URL des Dokumentes. */
  void setURL(const KURL& url);

  /** Gibt den Namen der Praesentation zurueck. */
  QString presentationName() const;
  
  /** Gibt den aktuellen Ablaufplan (Schedule) zurueck.  */
  Schedule& schedule();

  /**
   * Gibt das Dia mit dem Index @p idx des aktuellen Ablaufplanes zurueck.
   */
  Slide& slide(unsigned int idx);

  /** Gibt das aktuelle Dia des aktuellen Ablaufplanes zurueck. */
  Slide& slide();

  /** Gibt den Index im aktuellen Ablaufplan des aktuellen Dias zurueck. */
  int slideIdx() const;

  /** Gehe im Abplaufplan eine Position (Dia) vor. */
  void next();
  
  /** Gehe im Abplaufplan eine Position (Dias) zurueck. */
  void prev();

  /**
   *
   */
  void prevDay(unsigned int& newIdx);

  /**
   *
   */
  bool nextDay(unsigned int& newIdx);

  /** Gibt die Gesamtzeit der Praesentation in msec. zurueck. */
  int totalTime() const;
  
  /** Setzt die Presentation (Ablaufplan / Schedule) zurueck. */
  void reset();

  /** Ist das aktuelle Dia das Erste im Ablaufplan ? */
  bool isFirst() const;

  /** Ist das aktuelle Dia das Letzte im Ablaufplan ? */
  bool isLast() const;

  /**
   * Spule zu dem Dia, das bei @p msec angezeigt werden soll.
   * @return absolute Startzeit des Dias, zu dem durch diese Methode
   *         gespult wurde.
   */
  int seek(int msec);
  
  /**
   * Setzt den Ablaufplan (Schedule) als aktuell, der durch @p name
   * benannt wird.
   */
  void setScheduleByName(const QString& name);

  /** Gibt eine Liste der Strings mit den Ausloesungsnamen zurueck. */
  void resStrList(QStrList& res);
  

public:	// attribtues:

  /**
   * Die Liste der Views, die im Moment mit diesem Dokument verbunden sind.
   */
  static QList<KTourPresenterView> *pViewList;	


public slots:
  /**
   * Ruft <tt>repaint()</tt> von allen Views auf, die mit diesem
   * Dokumenten-Objekt verbunden sind. Sie werden durch die Views aufgerufen
   * wenn das Dokument geaendert wurde. Da die Views sich normalerweise selbst
   * repainten, ist es vom @p paintEvent ausgeschlossen.
   */
  void slotUpdateAllViews(KTourPresenterView *sender);
 	

signals:

  /**
   * Signal, das emittiert wird, wenn die Datei nicht geoeffnet werden konnte.
   * Bspw. wenn diese nicht existiert.
   */
  void sigCanNotOpenFile(const QString&);

  /**
   * Signal, das emittiert wird, wenn die Indexgrenze der Praesentation
   * ueberschritten wurde.
   */
  void sigEndOfSession();


protected: // methods:

  /** Liest eine Zeile aus der Datei, auf der @p *fileptr zeigt. */
  QString getline(FILE *fileptr);


protected: // attributes:

  /** Name der Praesentation. */
  QString presentationname;

  /** Menge der aufloesungsabhaengigen Ablaufplaene (Schedules). */
  vector<Schedule> schedules;

  /** Index des aktuellen Dias in dem Ablaufplan der Praesentation. */
  unsigned int picIdx;

  /** Index des aufloesungsabhaengigen Ablaufplanes. */
  int scheduleIdx;


private: // methods

  /**
   * Gibt die absolute Startzeit des Dias zurueck, in deren Abspieldauer die
   * absolute Zeit @p msec liegt. Die Suche wird durch die Index-Grenzen
   * @p lowIdx und @p highIdx begrenzt. Da die Dias zeitlich sortiert sind,
   * wird eine binaere Suche angewandt.
   */
  int seek(int msec, int lowIdx, int highIdx);
  

private: // attributes:

  /** URL des Dokumentes / der Abspieldatei. */
  KURL doc_url;

  /** Zeiger auf die Abspieldatei. */
  FILE *pFile;

};


#endif // KTOURPRESENTERDOC_H
