/***************************************************************************
    imlibwidget.h  -  Bildet ein Imlib-Image auf ein Qt Widget ab
    -------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.16 $
    CVS-ID    : $Id: imlibwidget.h,v 1.16 2002/02/02 19:41:02 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * basiert auf KuickShow 0.8.2 von Carsten Pfeiffer <pfeiffer@kde.org>
 */


#ifndef IMLIBWIDGET_H
#define IMLIBWIDGET_H


// Qt include files:
#include <qvariant.h>
#include <qevent.h>
#include <qlist.h>
#include <qtimer.h>
#include <qwidget.h>

// include those AFTER Qt-includes!
#include <Imlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

// Application include files:
#include "ktourimage.h"
#include "imagecache.h"


/**
 * Bildet ein Xlib-Fenster mit Imlib-Inhalt auf ein QWidget ab.
 *
 * @see KTourImage
 * @see ImageCache
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.16 $
 */
class ImlibWidget : public QWidget
{
  Q_OBJECT

public: 

  /** Erzeugt ein ImlibWidget. */
  ImlibWidget(QWidget *parent=0, const char *name=0, WFlags f=0);

  /** Erzeugt ein ImlibWidget unter Zuhilfenahme der ImlibData @p id.*/
  ImlibWidget(ImlibData *id, QWidget *parent=0, const char *name=0,
              WFlags f=0);
  /** Zerstoert das ImlibWidget. */
  virtual ~ImlibWidget();

  /** Gibt den Dateinamen dieser Imlib-Grafik zurueck. */
  const QString& filename() const { return m_filename; }

  /** Lade eine Grafik (in den Cache). */
  bool loadImage(const QString& filename, bool paintFlag=false);

  /** Loesche die Grafik. */
  void eraseImage();

  /**
   * Laedt die Grafik mit dem Dateinamen @p filename in den Cache.
   * @return <tt>true</tt>, wenn Operation geglueckt
   */
  bool cacheImage(const QString& filename);

  /** Skaliert die Imlib-Grafik. */
  void zoomImage(float);

  /** Setzt den Helligkeitswert dieser Grafik ( -256..256). */
  void setBrightness(int);

  /** Setzt den Kontrastwert dieser Grafik (-256..256). */
  void setContrast(int);

  /** Setzt den Gammawert dieser Grafik (-256..256). */
  void setGamma(int);

  /** Gibt den aktuellen Helligkeitswert dieser Grafik zurueck. */
  int brightness() const;

  /** Gibt den aktuellen Kontrastwert dieser Grafik zurueck. */
  int contrast() const;

  /** Gibt den aktuellen Gammawert dieser Grafik zurueck. */
  int gamma() const;

  /** Gibt die Breite des (skalierten) Bildes zurueck. */
  int imageWidth() const;

  /** Gibt die Hoehe des (skalierten) Bildes zurueck. */
  int imageHeight() const;

  /** */
  void setAutoRender(bool enable);

  /** */
  bool isAutoRenderEnabled() const;

  /** */
  void setMaxImageCache(int);

  /** Gibt die maximale Groesse des Caches zurueck. */
  int maxImageCache() const  { return m_maxImageCache; }

  /** Gibt die Hintergrundfarbe dieses Widgets zurueck. */
  const QColor& backgroundColor() const;

  /** Setzt die Hintergrundfarbe des Widgets. */
  void setBackgroundColor(const QColor&);

  /** Liefert den Zeiger auf die <tt>ImlibData</tt>-Variable zurueck. */
  ImlibData *getImlibData() const  { return id; }


public slots:

  /** */
  void showImageOriginalSize();

  /** setzte Hintergrundfarbe */
  void slotBackgroundColor(const QColor& color);

  inline void updateImage() { updateWidget(true); }


signals:

  /** Signalisiert ... */
  void sigBadImage(const QString&);


protected: // methods:

  /**
   * Initialisiert das <tt>ImlibWidget</tt> und erzeugt den
   * <tt>ImageCache</tt>.
   */
  void init();

  /**
   * Versucht @p filename zu laden und liefert bei Erfolg einen Pointer auf
   * das <tt>KTourImage</tt>-Objekt oder <tt>0L</tt>.
   */
  KTourImage *loadImageInternal(const QString& filename,
                                bool paintFlag=false);

  /** Zeigt das Bild. */
  void showImage();

  /** Waendet die Modifikatoren (Helligkeit, Kontrast und Gamma) an. */
  void setImageModifier();

  /** */
  void updateWidget(bool geometryUpdate=true);

  /** */
  virtual void updateGeometry(int width, int height);

  /** */
  void closeEvent(QCloseEvent *);

  /** */
  inline void	autoUpdate(bool geometryUpdate=false)
  {
    if ( m_isAutoRendering )
      updateWidget(geometryUpdate);
  }


protected: // attributes:

  bool stillResizing;
  bool deleteImlibData;

  /** Hat sich der Modifier (Helligkeit, Kontrast oder Gamma) geandert ? */
  bool imlibModifierChanged;

  /** Zeiger auf die eigentlichen Imlib-Daten. */
  KTourImage *ktimg;

  /** Der Image-Cache. */
  ImageCache *imageCache;

  /** Zeiger auf die ImlibData-Variable. */
  ImlibData *id;

  /** Das Lowlevel-X-Fenster. */
  Window win;

  /** Modifizierer fuer Helligkeit, Kontrast und Gamma-Wert. */
  ImlibColorModifier mod;

  /** Der Dateiname der Grafik. */
  QString m_filename;

  static const int ImlibOffset = 256;


protected slots:

  /**
   * Wechselt den Mauszeiger, der <em>Beschaeftigung</em> symbolisiert (z.B.
   * die Sanduhr).
   */
  void setBusyCursor();

  /** Zeige wieder den Standard-Mauszeiger. */
  void restoreCursor();


private:

  bool   m_isAutoRendering;
  int    m_maxImageCache;
  QColor m_backgroundColor;

};


#endif // END IMLIBWIDGET_H
