/***************************************************************************
    imagewindow.cpp  -  Erweitert ein ImlibWidget
    ---------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.22 $
    CVS-ID    : $Id: imagewindow.cpp,v 1.22 2002/02/03 14:03:29 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * basiert auf KuickShow 0.8.2 von Carsten Pfeiffer <pfeiffer@kde.org>
 */


// C include files:
#include <stdlib.h>

// STL include files:
#include <iostream>

// Qt include files:
#include <qcursor.h>
#include <qdrawutil.h>
#include <qkeycode.h>
#include <qmessagebox.h>
#include <qpainter.h>
#include <qpen.h>
#ifdef KDE_USE_FINAL
#undef GrayScale
#undef Color
#endif
#include <qrect.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtimer.h>
#include <qdragobject.h>
#include <qpoint.h>

// KDE include files:
#include <kaccel.h>
#include <kapp.h>       // fuer KDE_VERSION
#include <kconfig.h>
#include <kcursor.h>
#ifdef KDE_USE_FINAL
#undef Unsorted
#endif
#include <kfiledialog.h>
#include <klocale.h>
#include <kstdaccel.h>
#include <kstddirs.h>
#include <kwin.h>
#include <netwm.h>

// Application include files:
#include "imagewindow.h"
#include "globals.h"
#include "properties.h"

#if KDE_VERSION >= 291  // KDE 3.0beta1
#include <qapplication.h>
#endif

 
// erzeugt in main.cpp:
extern Properties *properties;


ImageWindow::ImageWindow(ImlibData *id, QWidget *parent, const char *name,
                         WFlags f)
 : ImlibWidget(id, parent, name, f)
{
  init();
} // END ImageWindow()


ImageWindow::ImageWindow(QWidget *parent, const char *name, WFlags f)
    : ImlibWidget(parent, name, f)
{
  init();
} // END ImageWindow()


ImageWindow::~ImageWindow()
{
} // END ~ImageWindow()


void ImageWindow::init()
{
  transWidget        = 0L;
  myIsFullscreen     = false;
  initialFullscreen  = properties->fullscreen();
  ignore_resize_hack = false;

  xpos = 0, ypos = 0;

  // Multihead ?
  m_numHeads = ScreenCount(x11Display());

  setAcceptDrops(false);
} // END init()


#if KDE_VERSION >= 220
void ImageWindow::setAutoHideEnabled(bool flag)
{
  KCursor::setAutoHideCursor(this, flag);
  KCursor::setHideCursorDelay(properties->hideDelay());
} // END setAutoHideEnabled()
#endif


void ImageWindow::setFullscreen(bool enable)
{
  xpos = 0; ypos = 0;

  if ( enable && !myIsFullscreen )
  {
    // set Fullscreen
    KWin::Info info = KWin::info(winId());
    oldGeometry = info.frameGeometry;

#if KDE_VERSION >= 291  // KDE 3.0beta1
    setFixedSize(QApplication::desktop()->screen()->size());
#else
    setFixedSize(QApplication::desktop()->size());
#endif
    KWin::setType(winId(), NET::Override);
    KWin::setState(winId(), NET::StaysOnTop);

    setGeometry(QApplication::desktop()->geometry());
  }
  else
  {
    if ( !enable && myIsFullscreen )
    {
      // go into window mode
    	bool wasInitialFullscreen = initialFullscreen;
    	initialFullscreen = false;
	
    	ignore_resize_hack = true; //ignore the resizeEvent triggered by move()
     	move(oldGeometry.topLeft());
     	setMinimumSize(0,0);
     	myIsFullscreen = false; // we want resizeOptimal to use window-mode
     	resizeOptimal(imageWidth(), imageHeight()); // resizeEvent centers

     	KWin::setType(winId(), NET::Normal);
     	KWin::clearState(winId(), NET::StaysOnTop);

     	// hack around kwin not giving us a decoration, when going into window
     	// mode and initially started in fullscreen mode
     	if ( wasInitialFullscreen )
   	    hide();
   	  show();
     } // END if !enable && myIsFullscreen

  } // END if enable && !myIsFullscreen

  myIsFullscreen = enable;
  centerImage(); // ### really necessary (multihead!)
} // END setFullscreeen()


bool ImageWindow::isFullscreen() const
{
  return myIsFullscreen;
} // END isFullscreen()


void ImageWindow::updateGeometry(int imWidth, int imHeight)
{
  //  XMoveWindow( x11Display(), win, 0, 0 );
  XResizeWindow( x11Display(), win, imWidth, imHeight );

  if ( imWidth != (int) m_width || imHeight != (int) m_height )
  {
    if ( myIsFullscreen )
    {
	    centerImage();
  	}
  	else
    { // window mode
	    // XMoveWindow( x11Display(), win, 0, 0 );
	    resizeOptimal(imWidth, imHeight); // also centers the image
    } // END if
  }
  else
  { // image size == widget size
    xpos = 0; ypos = 0;
    XMoveWindow( x11Display(), win, 0, 0 );
  } // END if

} // END updateGeometry()


void ImageWindow::centerImage()
{
  // von KuickShow:
  // Modified by Evan for his Multi-Head (2 screens)
  // This should center on the first head
  if ( myIsFullscreen && m_numHeads > 1 && ((m_numHeads % 2) == 0) )
    xpos = ((m_width/m_numHeads) / 2) - imageWidth()/2;
  else
    xpos = m_width/2 - imageWidth()/2;

  ypos = m_height/2 - imageHeight()/2;
  XMoveWindow( x11Display(), win, xpos, ypos );
} // END centerImage


bool ImageWindow::showNextImage(const QString& filename)
{
  if ( !loadImage(filename) )
  {
    emit sigBadImage(filename);

    return false;
  }
  else
  {
    doZooming(width(), height());
    showImage();
  } // END if

  return true;
} // END showNextImage()


void ImageWindow::addBrightness(int factor)
{
  if ( factor == 0 )
    return;

  int oldValue = mod.brightness - ImlibOffset;
  setBrightness(oldValue + (properties->brightnessFactor() * (int) factor));
} // END addBrightness()


void ImageWindow::addContrast(int factor)
{
  if ( factor == 0 )
    return;

  int oldValue = mod.contrast - ImlibOffset;
  setContrast(oldValue + (properties->contrastFactor() * (int) factor));
} // END addContrast()


void ImageWindow::addGamma(int factor)
{
  if ( factor == 0 )
    return;

  int oldValue = mod.gamma - ImlibOffset;
  setGamma(oldValue + (properties->gammaFactor() * (int) factor));
} // END addGamma()


void ImageWindow::slotMoreBrightness()
{
  addBrightness(properties->brightnessSteps());
} // END slotMoreBrightness()


void ImageWindow::slotMoreContrast()
{
  addContrast(properties->contrastSteps());
} // END slotMoreContrast()


void ImageWindow::slotMoreGamma()
{
  addGamma(properties->gammaSteps());
} // END slotMoreGamma()


void ImageWindow::slotLessBrightness()
{
  addBrightness(-properties->brightnessSteps());
} // END slotLessBrightness()


void ImageWindow::slotLessContrast()
{
  addContrast(-properties->contrastSteps());
} // END slotLessContrast()


void ImageWindow::slotLessGamma()
{
  addGamma(-properties->gammaSteps());
} // END slotLessGamma()


void ImageWindow::slotMaximize()
{
  if ( !ktimg )
    return;

  bool oldUpscale   = properties->upScale();
  bool oldDownscale = properties->downScale();

  properties->upScale(true);
  properties->downScale(true);

  updateWidget(true);

  if ( !myIsFullscreen )
    resizeOptimal(imageWidth(), imageHeight());

  properties->upScale(oldUpscale);
  properties->downScale(oldDownscale);
} // END slotMaximize()


void ImageWindow::resizeEvent(QResizeEvent *e)
{
  ImlibWidget::resizeEvent(e);

  if (ignore_resize_hack)
  {
    ignore_resize_hack = false;
	
    int w = width();
    int h = height();
    if ( w == QApplication::desktop()->width()  &&
         h == QApplication::desktop()->height() &&
         imageWidth() < w                       &&
         imageHeight() < h )
    {
      return;
    } // END if

  } // END if

  // to save a lot of calls in scrollImage() for example
  m_width  = width();
  m_height = height();

  doZooming(m_width, m_height);
} // END resizeEvent()


QSize ImageWindow::maxImageSize() const
{
  QSize result;

  if ( myIsFullscreen || initialFullscreen )
  {
    // fullscreen:
    result = QApplication::desktop()->size();
  }
  else
  {
    result = Globals::workArea().size() - Globals::frameSize( winId() );
  } // END if

  return result;
} // END maxImageSize()


void ImageWindow::resizeOptimal(int w, int h)
{
  QSize s = maxImageSize();
  int mw = s.width();
  int mh = s.height();
  int neww = (w >= mw) ? mw : w;
  int newh = (h >= mh) ? mh : h;

  if ( (neww == m_width) && (newh == m_height) )
    centerImage();
  else
    resize(neww, newh); // zentriert ebenfalls das Image

} // END resizeOptimal()


void ImageWindow::mousePressEvent(QMouseEvent *e)
{
  if ( e->button() == QMouseEvent::RightButton )
    emit sigPopup(e->globalPos());

} // END mousePressEvent()


void ImageWindow::doZooming(int width, int height)
{
  if ( !ktimg )
    return; // kein Image zu zoomen

  float faktorWidth =
    (float) width / (float) ktimg->width();
  float faktorHeight =
    (float) height / (float) ktimg->height();

  if ( faktorWidth < faktorHeight )
    zoomImage(faktorWidth);
  else
    zoomImage(faktorHeight);

  centerImage();
} // END doZooming()
