/***************************************************************************
    startuplogo.cpp  -  Zeigt das Logo beim Programmstart
    ---------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.7 $
    CVS-ID    : $Id: startuplogo.cpp,v 1.7 2002/01/01 18:28:25 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Qt include files:
#include <qstring.h>
#include <qfile.h>

// KDE include files:
#include <kapp.h>
#include <kstddirs.h>
#include <kcursor.h>

// Application include files:
#include "startuplogo.h"


StartupLogo::StartupLogo(QWidget *parent, const char *name) : 
  QWidget(parent, name, WStyle_Customize | WStyle_NoBorder)
{
  QString filename = locate("appdata", "startup.png");
  
  if ( QFile::exists(filename) )
  {
    setCursor(KCursor::waitCursor());

    QPixmap pm;
    pm.load(filename);
  
    setBackgroundPixmap(pm);
    
    // Stelle die Pixmap zentriert auf dem Bildschirm dar:
    setGeometry(QApplication::desktop()->width()/2  - pm.width()/2,
                QApplication::desktop()->height()/2 - pm.height()/2,
                pm.width(), pm.height());
  }
  else
  {
    qDebug("Can't open startup logo. File not found !");
  } // END if
}


bool StartupLogo::event(QEvent* ev)
{
  raise();

  return QWidget::event(ev);
}
