/***************************************************************************
    soundengine.h  -  Low Level Sound Engine
    -------------
    copyright : (C) 2001 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.5 $
    CVS-ID    : $Id: soundengine.h,v 1.5 2002/02/02 12:02:33 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * basiert auf Noatun
 */


#ifndef SOUNDENGINE_H
#define SOUNDENGINE_H


// Qt include files:
#include <qobject.h>
#include <qstring.h>
#include <qcstring.h>

// KDE/aRTs include files:
#include <arts/soundserver.h>
#include <arts/artsflow.h>
#include <arts/flowsystem.h>


/**
 * Basierend auf der Klasse <em>Engine</em> von Noatun von KDE 2.
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.5 $
 */
class SoundEngine : QObject
{
  Q_OBJECT
  
public: // methods:

  /**
   * Erzeugt die Lowlevel-Sound-Engine. Dafuer wird mittels initArts() eine
   * Verbindung zum Soundserver hergestellt.
   */
  SoundEngine();

  /** */
  ~SoundEngine();

  /**
   * Oeffnet die Sound-Datei @p filename, benutze play() zum
   * Abspielen dieser Datei.
   */
  bool open(const QString& filename);

  /**
   * Beginnt das Abspielen der mit open() geoeffneten Sound-Datei oder fuehrt
   * das Abspielen einer angehaltenen Sound-Ausgabe fort.
   */
  bool play();
  
  /** Unterbricht die Sound-Ausgabe, schliesst aber nicht die Sound-Datei. */
  void pause();
  
  /** Beendet die Sound-Ausgabe. */
  void stop();
  
  /** Springt zur Position @p newtime */
  void seek(int newTime);

  /** Gibt die aktuelle Zeit zurueck. */
  long currentTime();

  ///
  int state();
  
  Arts::SimpleSoundServer *server() const;
  Arts::SimpleSoundServer *simpleSoundServer() const;
  Arts::PlayObject playObject() const;
  
private: // methods:

  /**
   * Versucht die KDE-Multimediaarchitektur aRTs zu initialisieren.
   * @return konnte aRTs initialisiert werden ?
   */
  bool initArts();


private: // attributes:

  class SoundEnginePrivate;
  SoundEnginePrivate *d;

  bool              m_valid;
  QString           m_filename;
  Arts::Dispatcher *dispatcher;
  
};


#endif // END SOUNDENGINE_H
