/***************************************************************************
    slide.h  -  Repreasentiert ein Dia in einer Praesentation
    -------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.6 $
    CVS-ID    : $Id: slide.h,v 1.6 2002/01/31 12:12:06 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SLIDE_H
#define SLIDE_H


// Qt include files:
#include <qstring.h>


/**
 * Slide
 *
 * Repraesentiert ein Dia. Ein Objekt der Klasse Slide besteht aus folgenden
 * Attributen:
 * <ul>
 *   <li><tt>duration</tt>: Zeitdauer (msec.) fuer die Darstellung dieses
 *                          Dias.
 *   <li><tt>absTime</tt>: Absolute Zeit (msec.) seit Beginn der
 *                         Praesentation.
 *   <li><tt>dummy</tt>: <em>keine Ahnung</em> <tt>:-(</tt>
 *   <li><tt>picFilename</tt>: Dateiname des Dias incl. Pfad.
 * </ul>
 * Die Angaben <tt>absTime</tt>, <tt>dummy</tt> und <tt>picFilename</tt>
 * sind aus der Konfigurationsdatei der Praesentation zu entnehmen.
 * Die Zeitdauer fuer dieses Dia ergibt sich aus der Differenz der
 * <tt>absTime</tt> des Nachfolgedias und der <tt>absTime</tt> dieses Dias.
 * @see Schedule
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.6 $
 */
class Slide
{
public: // methods:

  /**
   * Erzeugt ein Slide mit der Darstellungsdauer @p duration (in msec.),
   * der absoluten Startzeit des Dias @p abstime (in msec), der <em>mir
   * unbekannten Zeit</em> :-( @p dummy und des Dateinamen (samt Pfad)
   * @p picfilename. Wenn @p duration nicht mit uebergeben wird, so wird
   * 0 als Default angenommen. Dieser Wert kann durch die Methode
   * <tt>duration(int)</tt> spaeter gesetzt werden.
   */
  Slide(int abstime, int dummy, const QString& picfilename, int duration=0);

  /**
   * Gibt die Zeitdauer (in msec.) fuer die Darstellung dieses Dias zurueck.
   */
  int duration() const;
  
  /**
   * Gibt die absolute Zeit (in msec.) seit Beginn der Praesentation fuer die
   * Startzeit dieses Dias zurueck.
   */
  int absTime() const;
  
  /** */
  int dummy() const;
  
  /** Gibt den Namen der Grafikdatei dieses Dias mit Pfad zurueck. */
  QString picFilename() const;

  /** Setzt die Abspieldauer des Dias. */
  void duration(int);

  /** Setzt den Dummy-Wert des Dias. */
  void dummy(int);


protected: // attribtues:

  /**
   * Absolute Zeit seit Praesentationsbeginn, nach der dieses Dia dargestellt
   * werden soll.
   */
  int m_abstime;

  /** */
  int m_dummy; // ???

  /** Name der zugehoerigen Grafikdatei (incl. Pfad). */
  QString m_picfilename;

  /** Zeitdauer, in der dieses Dia laut Ablaufplan angezeigt werden soll. */
  int m_duration;

};


#endif // SLIDE_H
