/***************************************************************************
    progressslider.h  -  Slider als Fortschrittsanzeige
    ----------------
    copyright : (C) 2001 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.6 $
    CVS-ID    : $Id: progressslider.h,v 1.6 2002/02/04 20:19:25 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef PROGRESSSLIDER_H
#define PROGRESSSLIDER_H


// Qt include files:
#include <qslider.h>
#include <qrect.h>


/**
 * ProgressSlider
 *
 * Implementiert einen Schieber fuer die Fortschrittsanzeige der
 * Praesentation. Er zeigt die Position in der Praesentation an, und
 * erlaubt durch Verschieben das Spulen zu einer bestimmten Position.
 * @see QSlider
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.6 $
 */
class ProgressSlider : public QSlider
{
  Q_OBJECT
    
public: // methods:

  /**
   * Erzeugt einen horizontalen Schieber zur Fortschittsanzeige der
   * Praesentation.
   */
  ProgressSlider(QWidget *parent=0, const char *name=0);

  /** */
  ~ProgressSlider();

  /**
   * Gibt die absolute Position (zwischen 0 und QSlider#maxValue()) zurueck.
   */
  int getSliderPos();

  /**
   * Gibt die relative Position (zwischen 0.0 und 1.0) des Schiebers zurueck.
   */
  double getSliderRelPos();


public slots:

  /**
   * Wird aufgerufen, wenn durch Mausaktion der Schieber zur absoluten
   * Position @p pos verschoben wurde.
   */
  void slotSliderMoved(int pos);


protected: // attributes:

  /** Absolute Position (zwischen 0 und maxValue()) des Schiebers. */
  int _pos;

};


#endif // END PROGRESSSLIDER_H
