/***************************************************************************
    progressslider.cpp  -  Slider als Fortschrittsanzeige
    ------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.10 $
    CVS-ID    : $Id: progressslider.cpp,v 1.10 2002/02/04 20:19:25 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// STL include files:
#include <iostream>

// Qt include files:
#include <qpoint.h>
#include <qstring.h>
#include <qtooltip.h>

// Application include files:
#include "progressslider.h"


ProgressSlider::ProgressSlider(QWidget *parent, const char *name) :
  QSlider(Horizontal, parent, name)
{
  setBackgroundMode(PaletteBase);
  setMinValue(0);
  
  _pos = 0;
  
  connect(this, SIGNAL(sliderMoved(int)), this, SLOT(slotSliderMoved(int)));
/*
  connect(this, SIGNAL(valueChanged(int)), this, SLOT(slotValueChanged(int)));
*/
} // END ProgressSlider()


ProgressSlider::~ProgressSlider()
{
} // END ~ProgressSlider()


int ProgressSlider::getSliderPos()
{
  return _pos;
} // END getSliderPos()


double ProgressSlider::getSliderRelPos()
{
  double maxPos = maxValue() - minValue();
  double actPos = (double) getSliderPos();
  
  return actPos / maxPos;
} // END getSliderRelPos()


void ProgressSlider::slotSliderMoved(int pos)
{
  _pos = pos;

} // END slotSliderMoved()
