/***************************************************************************
    ktourpresenterview.h  -  Haupt-Widget von KTourPresenter
    --------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.22 $
    CVS-ID    : $Id: ktourpresenterview.h,v 1.22 2002/02/03 14:03:29 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KTOURPRESENTERVIEW_H
#define KTOURPRESENTERVIEW_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// C include files:
#include <math.h>

// STL include files:
#include <iostream>
#include <vector>

// Qt include files:
#include <qwidget.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qsize.h>
#include <qwmatrix.h>

// KDE include files:
#include <kapp.h>  //fuer KDE_VERSION

// Application include files:
#include "progressslider.h"
#include "imagewindow.h"


// Forward-Deklarationen:
class KTourPresenterDoc;


/**
 * Die KTourPresenterView-Klasse liefert das Sicht-Widget der
 * KTourPresenterApp-Instanz. Die Sicht-Instanz leitet sich von der
 * Basis-Klasse QWidget ab und repraesentiert das Sicht-Objekt von einem
 * KMainWindow. Da KTourPresenterView Teil des Document-View-Model ist
 * benoetigt es einen Verweis auf das Dokumenten-Objektes, das mit der
 * KTourPresenterApp-Klasse verbunden ist, um die Dokumentenstruktur zu
 * manipulieren und anzuzeigen. Dieses wird durch die KTourPresenterDoc-Klasse
 * geliefert.
 * @see KTourPresenterApp
 * @see KTourPresenterDoc
 * @see ImageWindow
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.22 $
 */
class KTourPresenterView : public QWidget
{
  Q_OBJECT
  
public: // types:

  /**
   * Aufzaehlung der Dartstellungsmodi, in dem Arbeitsfenster @p Window
   * oder im Vollbildmodus @p Fullscreen.
   */
  enum ViewMode { Window, Fullscreen };


public: // methods:

  /**
   * Erzeugt eine <em>Sicht</em> auf das <em>Dokument</em>.
   * @see KTourPresenterDoc
   */
  KTourPresenterView(QWidget *parent = 0, const char *name=0);
    
  ~KTourPresenterView();

  /**
   * Gibt einen Zeiger auf das Dokument zurueck, das mit diese View-Instanz
   * verbunden ist. Zu beachten ist, dass diese Methode eine
   * KTourPresenterApp-Instanz als Eltern-Widget benoetigt, um mit der
   * KTourPresenterApp::getDocument() Methode an den Zeiger des Dokumentes
   * zu gelangen.
   * @see KTourPresenterApp#getDocument
   */
  KTourPresenterDoc *getDocument() const;

#if KDE_VERSION >= 220
  /** Schaltet 'Auto Hide' des Maus-Cursors der beiden Images ein/aus. */
  void setAutoHideEnabled(bool flag);
#endif

  /** Das darueberliegende View-Widget wurde in der Groesse veraendert. */
  void resizeEvent(QResizeEvent *);

  /** Loescht das Image und fuellt das Widget mit dem Hintergrund. */
  void eraseImage();

  /**
   * Laedt eine Grafik von einem lokalen Laufwerk. Die unterstuetzten
   * Grafikformate sind abhaengig von der Imlib.
   * @see KTourPresenterView#showImage
   */
  void loadImage(const QString& filename);

  /** Laedt eine Grafik in den Cache. */
  bool cacheImage(const QString& filename);

  /**
   * Zeigt das Bild, das sich im Hintergrundspeicher befindet. Anschliessend
   * ist der Hintergrundspeicher bereit um durch ein neues Bild ueberschrieben
 	 * zu werden. Das dargestellte Bild wird skaliert, damit in den
   * Arbeitsbereich (Fenster oder Vollbild) passt.
   * @see KTourPresenterView#loadImage
   */
  void showImage();

  /** Schaltet die Fortschrittsanzeige ein oder aus. */
  void setProgressEnabled(bool);

  /**
   * Setzt den Maximalwert fuer Fortschritts-Slider. Er entspricht der
   * Gesamtzeit der Praesentation in msec.
   */
  void setSliderMax(int maxValue);

  /**
   * Setzt die Gesamtzeit der Praesentation im Format Minuten:Sekunden.
   * Uebergeben wird die Zeit in msec.
   */
  void updateTotalTime(int msec);    

  /**
   * Setzt die aktuelle Praesentationszeit im Format Minuten:Sekunden.
   * Uebergeben wird die Zeit in msec.
   */
  void updateActTime(int msec);

  /** Passt die Slider-Position der uebergebenen Praesentation in msec. an. */
  void updateSlider(int msec);

  /**
   * Liefert den aktuellen Darstellungsmodus.
   * @see KTourPresenterView#ViewMode
   */
  ViewMode viewMode() const;


public slots:

  /**
   * Aufgerufen, wenn der Schieber mit der Maus veraendert wurde. Es muss das
   * passende Dia angezeigt werden.
   */
  void slotNewValue();

  void slotNewValue(int);

  /**
   * Setzte aktuelle und Gesamtzeit auf 00:00 und schalte die
   * Fortschrittszeile aus.
   */
  void slotReset();

  /** Aufgerufen, wenn die Hintergrundfarbe in @p color geaendert wurde. */
  void slotBackgroundColorChanged(const QColor& color);

  /** Helligkeits-, Kontrast- oder Gamma-Wert wurde geaendert. */
  void slotModifierChanged();

  /** Erhoehe Helligkeitswert. */
  void slotMoreBrightness();

  /** Vermindere Helligkeitswert. */
  void slotLessBrightness();

  /** Erhoehe Kontrastwert. */
  void slotMoreContrast();

  /** Vermindere Kontrastwert. */
  void slotLessContrast();

  /** Erhoehe Gamma-Wert. */
  void slotMoreGamma();

  /** Vermindere Gamma-Wert. */
  void slotLessGamma();

  /** Setze die Modifier (Helligkeit, Kontrast und Gamma-Wert) zurueck. */
  void slotResetModifier();

  /** Wechselt zwischen Vollbild- und Anwendungsfenstermodus. */
  void slotToggleFullscreen();


signals:
  
  /**
   * Emittiert, wenn die Schieber-Position durch die Mouse veraendert wurde.
   */
  void sigNewSliderPos(int);


protected: // attributes:

  /** Aktueller Darstellungsmodus. */
  ViewMode currMode;


private: // methods:

  /// gibt die Hoehe der Progress-Zeile zurueck:
  int progressHeight();

  /// gibt einen String mit Minuten und Sekunden zurueck:
  QString msecToString(int msec);


  /// liefert das Image im angegebenen Modus
  ImageWindow *image(ViewMode mode);


private: // attributes:

  // Vektor mit (nachher 2) Images (Fenster und Vollbild)
  vector<ImageWindow*> images;

  // 'Fortschritts-' Zeile:
  QLabel         *progressLabel;
  ProgressSlider *slider;
  QLabel         *actTime;
  QLabel         *slashLabel;
  QLabel         *totalTime;

  QString currImageFilename;

  //QSize oldSize;
};


#endif // KTOURPRESENTERVIEW_H
