/***************************************************************************
    ktourpresenterdoc.cpp  -  Dokumentenobjekt von KTourPresenter
    ---------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.24 $
    CVS-ID    : $Id: ktourpresenterdoc.cpp,v 1.24 2002/02/04 11:50:28 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// Qt include files:
#include <qdir.h>
#include <qfile.h>
#include <qwidget.h>

// KDE include files:
#include <kio/job.h>
#include <kio/netaccess.h>
#include <klocale.h>
#include <kmessagebox.h>

// Application include files:
#include "ktourpresenterdoc.h"
#include "ktourpresenter.h"
#include "ktourpresenterview.h"
#include "properties.h"


QList<KTourPresenterView> *KTourPresenterDoc::pViewList = 0L;

// erzeugt in main.cpp:
extern Properties *properties;


KTourPresenterDoc::KTourPresenterDoc(QWidget *parent, const char *name) : 
  QObject(parent, name)
{
  if ( !pViewList )
    pViewList = new QList<KTourPresenterView>();

  pViewList->setAutoDelete(true);
  
  scheduleIdx = 0;
} // END KTourPresenterDoc()


KTourPresenterDoc::~KTourPresenterDoc()
{
} // END ~KTourPresenterDoc()


void KTourPresenterDoc::addView(KTourPresenterView *view)
{
  pViewList->append(view);
} // END addView()


void KTourPresenterDoc::removeView(KTourPresenterView *view)
{
  pViewList->remove(view);
} // END removeView()


void KTourPresenterDoc::setURL(const KURL &url)
{
  doc_url=url;
} // END setURL()


const KURL& KTourPresenterDoc::URL() const
{
  return doc_url;
} // END URL()


void KTourPresenterDoc::slotUpdateAllViews(KTourPresenterView *sender)
{
  KTourPresenterView *w;
  
  if ( pViewList )
  {
    for ( w = pViewList->first(); w != 0; w = pViewList->next() )
    {
      if ( w != sender )
        w->repaint();
    } // END for
  } // END if

} // END slotUpdateAllViews()


void KTourPresenterDoc::closeDocument()
{
  deleteContents();
  
  if ( pFile != 0)
  {
    fclose(pFile);
    pFile = 0;
  } // END if
} // END closeDocument()


bool KTourPresenterDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  //doc_url.setFileName(i18n("Untitled"));

  return true;

} // END newDocument()


bool KTourPresenterDoc::openDocument(const KURL& url)
{
  QString tmpfile;
  KIO::NetAccess::download(url, tmpfile);

  if ( url.isValid() )
  {
    QString protocol = url.protocol();
    QString pathfile = url.path();
    
    if ( protocol != "file" )
    {
      KMessageBox::sorry(0,
                         i18n("You can only choose a local file.\n"
                              "Remote files are not supported !"),
                         i18n("Error"));
          
      return false;
    }
    else
    {
      // lade Datei:
      if ( QFile::exists(pathfile) )
      {
        // play.ini ist folgendermassen aufgebaut:
        //
        // +--------------------------------------------------------------+
        // | 1: "Name der Praesentation"                                  |
        // | 2: "Aufloesungsstring" "Dateiname der aufloesungsabh. Datei" |
        // | 3: "Aufloesungsstring" "Dateiname der aufloesungsabh. Datei" |
        // |    ...                                                       |
        // +--------------------------------------------------------------+
        //
        // Die doppelten Anfuehrungszeichen sind nicht Teil der Zeichenketten
        // in der Datei, sollen die Grenzen der einzelnen Strings hier
        // markieren. Auch die Zeilennummern sind nicht Teil der Datei.

        pFile = fopen(pathfile.data(), "r");

        // Konnte Datei geoffnet werden ?
        if ( pFile == 0 )
          emit sigCanNotOpenFile(pathfile);

        if ( !feof(pFile) )
        {
          // lese den Namen der Praesentation:
          presentationname = getline(pFile);

          // lese die Dateinamen der (Unter-) Praesentationen:
          QString line, res, name;
          int pos;
          while ( !feof(pFile) )
          {
            line = getline(pFile);

      	    if ( !feof(pFile) )
            {
              pos = line.find(" ");
              res = line.mid(0, pos);
              name = line.mid(pos+1, line.length());

              schedules.push_back(Schedule(res, name));
            } // END if

          } // END while

        } // END if feof

        picIdx      = 0;  // die Default-Grafik im ...
        scheduleIdx = 0;  // ... 1. Ablaufplan sind aktuell
      }
      else
      {
        KMessageBox::sorry(0L,
            i18n("Can't open %1. File not found !").arg(pathfile),
            i18n("File not found"));

        return false;
      } // END if exists()
    } // END if protocol != file
  }
  else
  {
    return false;
  } // END if isValid()
  
  KIO::NetAccess::removeTempFile(tmpfile);

  return true;

} // END openDocument()


void KTourPresenterDoc::deleteContents()
{
  while ( schedules.size() > 0 )
    schedules.erase(schedules.begin());
} // END deleteContents()


QString KTourPresenterDoc::presentationName() const
{
  return presentationname;
} // END presentationName()


Schedule& KTourPresenterDoc::schedule()
{
  return schedules[scheduleIdx];
} // END schedule()


Slide& KTourPresenterDoc::slide(unsigned int idx)
{
  return schedule().slide(idx);
} // END slide()


Slide& KTourPresenterDoc::slide()
{
  return schedules[scheduleIdx].slide(picIdx);
} // END slide()


int KTourPresenterDoc::slideIdx() const
{
  return picIdx;
}


void KTourPresenterDoc::next()
{
  picIdx++;
} // END next()


void KTourPresenterDoc::prev()
{
  picIdx--;
} // END prev()
  

void KTourPresenterDoc::prevDay(unsigned int& newPicIdx)
{
  schedules[scheduleIdx].prevDay(picIdx, newPicIdx);
} // END slotControlPrevDay()


bool KTourPresenterDoc::nextDay(unsigned int& newPicIdx)
{
  return schedules[scheduleIdx].nextDay(picIdx, newPicIdx);
} // END slotControlNextDay()


int KTourPresenterDoc::totalTime() const
{
  return schedules[scheduleIdx].duration();
} // END totalTime()


void KTourPresenterDoc::reset()
{
  picIdx = 0;
} // END reset()


bool KTourPresenterDoc::isFirst() const
{
  return ( picIdx < 1 );
} // END isFirst()


bool KTourPresenterDoc::isLast() const
{
  return ( (schedules[scheduleIdx].size() - picIdx) < 1 );
} // END isLast()


int KTourPresenterDoc::seek(int msec)
{
  int lowIdx  = 0;
  int highIdx = schedules[scheduleIdx].size() - 1;

  // benutze eine Art von binaerer Suche fuer das zu suchende Dia
  return seek(msec, lowIdx, highIdx);
} // END seek()


void KTourPresenterDoc::setScheduleByName(const QString& name)
{
  int idx = 0;
  vector<Schedule>::const_iterator it;
  for ( it = schedules.begin(); it != schedules.end(); it++, idx++ )
  {
    if ( name == it->resolutionString() )
    {
      // wurde wirklich eine neue Aufloesung gewaehlt ?
      if ( scheduleIdx != idx )
      {
        scheduleIdx = idx;
#ifndef NDEBUG
        cerr << "KTourPresenterDoc::setPresentation(" << name <<"); "
             << "new subsession idx = " << idx << endl;
#endif
      } // END if scheduleIdx

    } // END if name

  } // END for

} // END setSchedukeByName()


void KTourPresenterDoc::resStrList(QStrList& res)
{
  res.clear();

  vector<Schedule>::const_iterator it;
  for ( it = schedules.begin(); it != schedules.end(); it++ )
  {
    res.append( it->resolutionString() );
  } // END for

} // END resStrList()


// protected:
// ----------

QString KTourPresenterDoc::getline(FILE *fileptr)
{
  QString line;
  char buffer[255];

  if ( (fileptr != 0) && (!feof(fileptr)) )
  {
    // lese die naechste Zeile:
    fgets(buffer, 255, fileptr);

    line = buffer;
    if ( line[line.length()-1] == '\n' )
    {
      line = line.mid(0, line.length()-2);
    }

    return line;
  } // END if

  return "";

} // END getline()


// private:
// --------

int KTourPresenterDoc::seek(int msec, int lowIdx, int highIdx)
{
  int midIdx  = ( (highIdx - lowIdx) / 2 ) + lowIdx;
  
  int midIdxTime  = schedules[scheduleIdx].slide(midIdx).absTime();
  int midIdx2Time = schedules[scheduleIdx].slide(midIdx+1).absTime();

  if ( (midIdxTime <= msec) && (msec < midIdx2Time) )
  {
    // Dia gefunden

    picIdx = midIdx;
  }
  else
  {
    if ( msec < midIdxTime )
    {
      // lowIdx <= msec < midIdx

      return seek(msec, lowIdx, midIdx);
    }
    else
    {
      // midIdx < msec <= highIdx

      return seek(msec, midIdx, highIdx);
    } // END if

  } // END if
  
  return midIdxTime;

} // END seek()
