/***************************************************************************
    ktourimage.h  -  Repraesentiert ein ImlibImage
    ------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.8 $
    CVS-ID    : $Id: ktourimage.h,v 1.8 2002/02/02 19:21:58 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * basiert auf KuickShow 0.8.2 von Carsten Pfeiffer <pfeiffer@kde.org>
 */

 
#ifndef KUICKIMAGE_H
#define KUICKIMAGE_H


// Qt include files:
#include <qvariant.h>
#include <qevent.h>
#include <qlist.h>
#include <qtimer.h>
#include <qwidget.h>

// include those AFTER Qt-includes!
#include <Imlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>


/**
 * KTourImage
 *
 * Repraesentiert ein Imlib Image.
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.8 $
 */
class KTourImage : public QObject
{
  Q_OBJECT
  
public:

  /**
   * Erzeugt ein @p KTourImage mit dem Dateinamen @p filename, und den
   * Imlib-Daten @p im und @p id.
   */
  KTourImage(const QString& filename, ImlibImage *im, ImlibData *id,
             bool paintFlag=false);

  /** */
  ~KTourImage();

  /** Gibt die (skalierte) Breite des Bildes zurueck. */
  int width() const;

  /** Gibt die (skalierte) Hoehe des Bildes zurueck. */
  int height() const;

  /** Gibt die (originale) Breite des Bildes zurueck. */
  int originalWidth() const;

  /** Gibt die (originale) Hoehe des Bildes zurueck. */
  int originalHeight() const;

  /**
   * Skaliert unter Beibehaltung des Seitenverhaeltnisses das Bild auf die
   * Groesse @p width x @p height.
   */
  void resize(int width, int height);

  /** Stellt die originale Groesse wieder her. */
  void restoreOriginalSize();

  /** Gibt die Imlib-Image zurueck. */
  ImlibImage *imlibImage() const;

  /** Liefert die Imlib-Daten dieses Images zurueck. */
  ImlibData *imlibData() const;

  /** Gibt die (X Window) Pixmap zurueck. */
  Pixmap& pixmap();

  /** Stellt das Bild dar. */
  void renderPixmap();

  /**
   * Setzt das <em>Dirty Flag</em>. Es zeigt an, ob das Bild neu gezeichnet
   * werden muss.
   */
  void setDirty(bool d);

  /** Ist das <em>Dirty Flag</em> gesetzt ? */
  bool isDirty() const;

  /** Gibt den Dateinamen der Grafik zurueck. */
  const QString& filename() const;


signals:

  /** Signalisiert, dass das Rendern des Bildes begonnen hat. */
  void startRendering();

  /** Signalisiert, dass das Rendern des Bildes beendet wurde. */
  void stoppedRendering();


protected: // attributes

  /** Skalierte Breite der Grafik. */
  int m_width;

  /** Skalierte Hoehe der Grafik. */
  int m_height;

  /** Originalbreite der Grafik. */
  int m_origWidth;

  /* Originalhoehe der Grafik. */
  int m_origHeight;

  /** Dateiname der Grafik. */
  QString m_filename;

  /** */
  ImlibImage *m_im;

  /** Daten ueber eine ImlibImage. */
  ImlibData  *m_id;

  /** X-Pixmap der Grafik, diese kann auf ein QWidget abgebildert werden. */
  Pixmap m_pixmap;

  /**
   * Ist die (skalierte) Grafik noch aktuell, oder sie muss neu gerendert
   * werden ?
   */
  bool m_isDirty;

};


#endif // END KTOURIMAGE_H
