/***************************************************************************
    imagewindow.h  -  Erweitert ein ImlibWidget
    -------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.15 $
    CVS-ID    : $Id: imagewindow.h,v 1.15 2002/02/03 14:03:29 dirk Exp $

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * basiert auf KuickShow 0.8.1 von Carsten Pfeiffer <pfeiffer@kde.org>
 */


#ifndef IMAGEWINDOW_H
#define IMAGEWINDOW_H


// Qt include files:
#include <qevent.h>
#include <qstring.h>
#include <qrect.h>

// KDE include files:
#include <kapp.h>  // fuer KDE_VERSION

// Application include files:
#include "imlibwidget.h"


/**
 * ImageWindow
 *
 * Erweitert ein ImlibWidget um High-Level-Funktionalitaet.
 * @see ImlibWidget
 *
 * @author Dirk Rosert <dirk@kiste.ping.de>
 * $Revision: 1.15 $
 */
class ImageWindow : public ImlibWidget
{
  Q_OBJECT

public:

  /**
   * Erzeugt ein ImageWindow unter zuhilfenahme der ImlibData @p *id.
   */
  ImageWindow(ImlibData *id, QWidget *parent=0, const char *name=0,
              WFlags f=0);

  /**
   * Erzeugt ein ImageWindow mit standardmaessige ImlibData's.
   */
  ImageWindow(QWidget *parent=0, const char *name=0, WFlags f=0);

  /**
   * Zeige das naechste Bild mit dem Namen @p filename.
   */
  bool showNextImage(const QString& filename);

#if KDE_VERSION >= 220
  /** Schaltet 'Auto Hide' fuer den Mauszeiger ein/aus. */
  void setAutoHideEnabled(bool flag);
#endif

  /** Setzt den Vollbildmodus (ja oder nein). */
  void setFullscreen(bool);

  /** Ist der Vollbildmodus gesetzt ? */
  bool isFullscreen() const;

  /** Fuege Helligkeit zum Bild hinzu. */
  void addBrightness(int);

  /** Fuege Kontrast zum Bild hinzu. */
  void addContrast(int);

  /** Fuege Gamma-Wert zum Bild hinzu. */
  void addGamma(int);

  /**
   * Veraendere die Groesse des Bildes nach @p wm @p h. Es wird aber die
   * Groesse des Arbeitsbereiches beachtet, so dass es nicht Groesser als der
   * Arbeitsbereich wird.
   */
  void resizeOptimal(int w, int h);


public slots:

  /** Erhoehe die Helligkeit. */
  void slotMoreBrightness();

  /** Vermindere die Helligkeit. */
  void slotLessBrightness();

  /** Erhoehe den Kontrast. */
  void slotMoreContrast();

  /** Vermindere den Kontrast. */
  void slotLessContrast();

  /** Erhoehe den Gamma-Wert. */
  void slotMoreGamma();

  /** Vermindere den Gamma-Wert. */
  void slotLessGamma();

  /** */
  void slotMaximize();


signals:

  /**
   * Signalisiert, dass das Fenster den Fokus erhalten hat.
   */
  void sigFocusWindow(ImageWindow *);

  /**
   * Signalisiert, dass das Kontextmenue an Position @p pos angezeigt werden
   * soll.
   */
  void sigPopup(const QPoint &pos);


protected: // methods:

  /** */
  ~ImageWindow();

  /** Initilisiert das ImageWindow. */
  void init();

  /** Zentriert das Image. */
  void centerImage();

  /** */
  virtual void updateGeometry(int imWidth, int imHeight);

  virtual void resizeEvent(QResizeEvent *);

  /** Reimplementiert QWidget#mousePressEvent(). */
  virtual void mousePressEvent(QMouseEvent *e);


protected: // attributes:

  // linke obere Ecke des Bildes:
  int	xpos, ypos;

  QRect oldGeometry;

  QWidget *transWidget;

  ImageCache *imageCache;


private: // methods:

  /** */
  QSize	maxImageSize() const;

  /** Fuehrt das Zooming durch. */
  void doZooming(int, int);


private: // attributes

  bool myIsFullscreen;
  bool initialFullscreen;
  int m_width;
  int m_height;
  int m_numHeads;

  // Qt resizes us even if we just request a move(). This sucks when
  // switching from fullscreen to window mode, as we will be resized twice.
  bool ignore_resize_hack;
};


#endif // END IMAGEWINDOW_H
