/***************************************************************************
    configuredialog.cpp  -  Konfigurations-Dialog von KTourPresenter
    -------------------
    copyright : (C) 2001, 2002 by Dirk Rosert
    email     : dirk@kiste.ping.de
    author    : $Author: dirk $
    revision  : $Revision: 1.36 $
    CVS-ID    : $Id: configuredialog.cpp,v 1.36 2002/02/14 14:44:27 dirk Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// STL include files:
#include <iostream>

// Qt include files:
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtabwidget.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

// KDE include files:
#include <kiconloader.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kkeydialog.h>
#include <kstddirs.h>

// Application include files:
#include "configuredialog.h"
#include "properties.h"


// erzeugt in main.cpp:
extern Properties *properties;


ConfigureDialog::ConfigureDialog(QWidget *parent, const char *name,
                                 KAccel *accel, KMainWindow *toplevel,
                                 bool modal)
:   KDialogBase(IconList, i18n("Configure"), Default|Apply|Ok|Cancel, Ok,
                parent, name, modal, true),
  m_accel(accel),
  m_toplevel(toplevel),
  m_oldBrightness(properties->brightness()),
  m_oldContrast(properties->contrast()),
  m_oldGamma(properties->gamma()),
  m_toolbarDirty(false)

{
  // baue die einzelnen Seiten auf:
  setupGeneralPage();
  setupPresentationPage();
  setupImagePage();
#if KDE_VERSION < 290
  setupKeysPage();
#endif
  setupToolbarPage();

} // END ConfigureDialog()


ConfigureDialog::~ConfigureDialog()
{
} // END ~ConfigureDialog()


void ConfigureDialog::setValues()
{
  // [General]
  m_general.basePathLE->setText(properties->base());
  m_general.defaultImgFileLE->setText(properties->defaultImageFilename());
  m_general.reportFileLE->setText(properties->reportFilename());
  m_general.browserNameLE->setText(properties->browserName());

  // [Presentation]
  m_presentation.autoLoadCB->setChecked(properties->autoLoad());
  m_presentation.autoStartCB->setChecked(properties->autoStart());
  m_presentation.fullscreenCB->setChecked(properties->fullscreen());
  m_presentation.backgroundButton->setColor(properties->backgroundColor());
#if KDE_VERSION >= 220
  m_presentation.disableSSaverCB->setChecked(
                                         properties->disableScreensaver());
  // *** FIXME: vvv im Moment nicht vorhanden !!! vvv
  //m_presentation.hideMouseCB->setChecked(properties->hideMouse());
#endif

  // [Imlib]
  m_image.cbDownScale->setChecked(properties->downScale());
  m_image.cbUpScale->setChecked(properties->upScale());
  m_image.sbMaxUpScaleFactor->setValue(properties->maxUpScale());
  m_image.cbFastRender->setChecked(properties->fastRender());
  m_image.cbDither16bit->setChecked(properties->dither16bit());
  m_image.cbDither8bit->setChecked(properties->dither8bit());
  m_image.cbOwnPalette->setChecked(properties->ownPalette());
  m_image.cbFastRemap->setChecked(properties->fastRemap());
  m_image.maxCacheSpinBox->setValue(properties->maxCache() / 1024);
  m_image.sbBrightness->setValue(properties->brightness());
  m_image.sbContrast->setValue(properties->contrast());
  m_image.sbGamma->setValue(properties->gamma());

  // [Keys]

} // END setValues();


void ConfigureDialog::setupGeneralPage()
{
  QFrame *page = addPage( i18n("General"), i18n("General Settings"),
                          BarIcon("misc", KIcon::SizeMedium) );
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());


  // <<< Groupe box: file and directory names >>>
  QGroupBox *fileDirGroup;
  fileDirGroup = new QGroupBox(page, "filedirgroup");

  QGridLayout *gridLayout1 =
    new QGridLayout(fileDirGroup, 4, 3, 20, 10, "filedirgroup");
  fileDirGroup->setTitle(i18n("File and directory names"));

  // base:
  QLabel *basePathLabel = new QLabel(i18n("Base path of the presentation"),
                                     fileDirGroup, "basepathlabel");
  m_general.basePathLE = new QLineEdit(properties->base(), fileDirGroup,
                                      "basepathlineedit");
  m_general.basePathPB = new QPushButton(fileDirGroup, "basepathselect");
  m_general.basePathPB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.basePathPB, SIGNAL(clicked()),
          this, SLOT(slotOpenBasePath()));
  gridLayout1->addWidget(basePathLabel,        0, 0);
  gridLayout1->addWidget(m_general.basePathLE, 0, 1);
  gridLayout1->addWidget(m_general.basePathPB, 0, 2);
  QString baseTT =
    i18n("In opposition to the Windows application KTourPresenter "
         "is not located on the tour CD. KTourPresenter needs to "
         "know where the presentation lies (e.g. <tt>/cdrom</tt> "
         "or <tt>/media/cdrom</tt>).");
  QWhatsThis::add(m_general.basePathLE, baseTT);

  // play file:
  QLabel *playFileLabel =
    new QLabel(i18n("Name of the presentation file"), fileDirGroup,
                    "playfilelabel");
  m_general.playFileLE =
    new QLineEdit(properties->playFilename(), fileDirGroup,
                  "playfilelineedit");
  m_general.playFilePB = new QPushButton(fileDirGroup, "playfileselect");
  m_general.playFilePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.playFilePB, SIGNAL(clicked()),
          this, SLOT(slotOpenPlayFile()));
  gridLayout1->addWidget(playFileLabel,        1, 0);
  gridLayout1->addWidget(m_general.playFileLE, 1, 1);
  gridLayout1->addWidget(m_general.playFilePB, 1, 2);
  QString playTT =
    i18n("");
  QWhatsThis::add(m_general.playFileLE, playTT);

  // default image:
  QLabel *defaultImgFileLabel =
    new QLabel(i18n("Filename of the default image"), fileDirGroup,
                    "defimgfilelabel");
  m_general.defaultImgFileLE =
    new QLineEdit(properties->defaultImageFilename(), fileDirGroup,
                  "defimgfilelineedit");
  m_general.defaultImgFilePB =
    new QPushButton(fileDirGroup, "defimgfileselect");
  m_general.defaultImgFilePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.defaultImgFilePB, SIGNAL(clicked()),
          this, SLOT(slotOpenDefaultImg()));
  gridLayout1->addWidget(defaultImgFileLabel,        2, 0);
  gridLayout1->addWidget(m_general.defaultImgFileLE, 2, 1);
  gridLayout1->addWidget(m_general.defaultImgFilePB, 2, 2);
  QString defaultTT =
    i18n("Name of the image file that will be shown when the presentation "
         "is not running.");
  QWhatsThis::add(m_general.defaultImgFileLE, defaultTT);

  // report filename
  QLabel *reportFileLabel =
    new QLabel(i18n("Name of the report file"), fileDirGroup,
               "reportfilelabel");
  m_general.reportFileLE =
    new QLineEdit(properties->reportFilename(), fileDirGroup,
                  "reportfilelineedit");
  m_general.reportFilePB = new QPushButton(fileDirGroup, "reportfileselect");
  m_general.reportFilePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.reportFilePB, SIGNAL(clicked()),
          this, SLOT(slotOpenReportFile()));
  gridLayout1->addWidget(reportFileLabel,        3, 0);
  gridLayout1->addWidget(m_general.reportFileLE, 3, 1);
  gridLayout1->addWidget(m_general.reportFilePB, 3, 2);
  QString reportTT =
    i18n("Filename of the tour report. If this file does not exists the "
         "report browser is disabled.");
  QWhatsThis::add(m_general.reportFileLE, reportTT);


  // <<< Groupe box: report browser >>>
  QGroupBox *reportGroup;
  reportGroup = new QGroupBox(page, "reportgroup");

  QGridLayout *gridLayout2 =
    new QGridLayout(reportGroup, 3, 3, 20, 10, "reportgrouplayout");

  reportGroup->setTitle(i18n("Report browser"));

  // name of the browser
  QLabel *browserNameLabel =
    new QLabel(i18n("Name of the browser"), reportGroup, "browsernamelabel");
  m_general.browserNameLE = new QLineEdit(properties->browserName(),
                                         reportGroup, "browsernamelineedit");

  m_general.browserNamePB = new QPushButton(reportGroup, "browsernameselect");
  m_general.browserNamePB->setPixmap(SmallIcon("fileopen"));
  connect(m_general.browserNamePB, SIGNAL(clicked()),
          this, SLOT(slotOpenBrowser()));
  gridLayout2->addWidget(browserNameLabel,        1, 0);
  gridLayout2->addWidget(m_general.browserNameLE, 1, 1);
  gridLayout2->addWidget(m_general.browserNamePB, 1, 2);
  QString browserTT =
    i18n("Name of the external browser, e.g. <tt>konqeror</tt>,"
         "<tt>netscape</tt>, <tt>mozilla</tt> or purists maybe "
         "choose <tt>xterm -e lynx</tt> <tt>;-)</tt>");
  QWhatsThis::add(m_general.browserNameLE, browserTT);


  // Layout:
  topLayout->addWidget(fileDirGroup);
  topLayout->addWidget(reportGroup);

} // END setupGeneralPage()


void ConfigureDialog::setupPresentationPage()
{
  QFrame *page = addPage( i18n("Presentation"), i18n("Presentation Settings"),
                          BarIcon("queue", KIcon::SizeMedium) );
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());


  // <<< Groupe box: file and directory names >>>
  QGroupBox *generalGroup;
  generalGroup = new QGroupBox(page, "generalgroup");
  generalGroup->setTitle(i18n("General"));

  //
  QGridLayout *gridLayout =
    new QGridLayout(generalGroup, 7, 2, 20, 10, "generalgroup");

  QLabel *autoLoadLabel =
    new QLabel(i18n("Automatic loading of the presentation on startup"),
               generalGroup, "autoLoadLabel");
  m_presentation.autoLoadCB = new QCheckBox(" ", generalGroup, "autoloadcb");
  m_presentation.autoLoadCB->setChecked(properties->autoLoad());
  gridLayout->addWidget(autoLoadLabel,             0, 0);
  gridLayout->addWidget(m_presentation.autoLoadCB, 0, 1);

  QLabel *autoStartLabel =
    new QLabel(i18n("Automatic starting of a loaded presentation"),
               generalGroup, "autoStartLabel");
  m_presentation.autoStartCB = new QCheckBox(" ", generalGroup, "autostartcb");
  m_presentation.autoStartCB->setChecked(properties->autoStart());
  gridLayout->addWidget(autoStartLabel,             1, 0);
  gridLayout->addWidget(m_presentation.autoStartCB, 1, 1);

  QLabel *autoQuitLabel =
    new QLabel(i18n("Automatic quit application after presentation"),
               generalGroup, "autoQuitLabel");
  m_presentation.autoQuitCB = new QCheckBox(" ", generalGroup, "autoquitcb");
  m_presentation.autoQuitCB->setChecked(properties->autoQuit());
  gridLayout->addWidget(autoQuitLabel,             2, 0);
  gridLayout->addWidget(m_presentation.autoQuitCB, 2, 1);

  QLabel *autoFullscreenLabel =
    new QLabel(i18n("Start presentation in fullscreen"),
               generalGroup, "autoFullscreenLabel");
  m_presentation.fullscreenCB =
    new QCheckBox(" ", generalGroup, "fullscreencb");
  m_presentation.fullscreenCB->setChecked(properties->fullscreen());
  gridLayout->addWidget(autoFullscreenLabel,         3, 0);
  gridLayout->addWidget(m_presentation.fullscreenCB, 3, 1);

#if KDE_VERSION >= 220
  // Bildschrimschoner ausschalten
  QLabel *disableSSaverLB =
    new QLabel(i18n("Try to disable screen saver during the presentation"),
               generalGroup, "disablessaverlabel");
  m_presentation.disableSSaverCB =
    new QCheckBox(" ", generalGroup, "disablessavercb");
  m_presentation.disableSSaverCB->setChecked(
                                    properties->disableScreensaver());
  gridLayout->addWidget(disableSSaverLB,                4, 0);
  gridLayout->addWidget(m_presentation.disableSSaverCB, 4, 1);
#endif

  // Hintergrundfarbe
  QLabel *backgroundLabel =
    new QLabel(i18n("Background Color"), generalGroup, "backgroundlabel");
  m_presentation.backgroundButton = new KColorButton(generalGroup);
  m_presentation.backgroundButton->setColor(properties->backgroundColor());
  gridLayout->addWidget(backgroundLabel,                 5, 0);
  gridLayout->addWidget(m_presentation.backgroundButton, 5, 1);
  m_presentation.backgroundButton->setFixedWidth(
    2*m_presentation.backgroundButton->height());

#if KDE_VERSION >= 220
  // Mauszeiger ausblenden
  /*
  QLabel *hideMouseLabel =
    new QLabel(i18n("Hide Mouse Cursor"), generalGroup, "hidemouselabel");
  m_presentation.hideMouseCB =
    new QCheckBox(" ", generalGroup, "hidemousecb");
  m_presentation.hideMouseCB->setChecked(properties->hideMouse());
  gridLayout->addWidget(hideMouseLabel,             6, 0);
  gridLayout->addWidget(m_presentation.hideMouseCB, 6, 1);
  */
#endif

  // Layout:
  topLayout->addWidget(generalGroup);
  topLayout->addStretch(1);

} // END setupPresentationPage()


void ConfigureDialog::setupImagePage()
{
  QFrame *page = addPage(i18n("Image"), i18n("Image Settings"),
                         BarIcon("background", KIcon::SizeMedium));
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());

  // *** Widgets ***

  // Tab-Widget:
  QTabWidget *tabWidget   = new QTabWidget(page, "tabwidget");
  QWidget    *tabContent1 = new QWidget(tabWidget, "tabcontent1");
  QWidget    *tabContent2 = new QWidget(tabWidget, "tabcontent2");

  // Skalieren:
  QGroupBox *gbScale = new QGroupBox(i18n("Scaling"), tabContent1);
  m_image.cbDownScale =
    new QCheckBox(i18n("Shrink image to screensize, if larger"),
			            gbScale, "shrinktoscreen");
  m_image.cbDownScale->setChecked(properties->downScale());

  m_image.cbUpScale = new QCheckBox(
    i18n("Scale image to screensize, if smaller, up to factor:"),
                  gbScale, "upscale checkbox" );
  m_image.cbUpScale->setChecked(properties->upScale());
  connect(m_image.cbUpScale, SIGNAL(toggled(bool)),
                             SLOT(slotEnableMaxScale(bool)));

  m_image.sbMaxUpScaleFactor =
    new KIntNumInput(gbScale, "upscale factor" );
  m_image.sbMaxUpScaleFactor->setRange(1, 100, 1, false);
  m_image.sbMaxUpScaleFactor->setValue(properties->maxUpScale());
  m_image.sbMaxUpScaleFactor->setEnabled(properties->upScale());

  // Qualitaet / Geschwindigkeit:
  QVGroupBox *vgbQual = new QVGroupBox(i18n("Quality / Speed"), tabContent1,
                                     "qualitybox");

  m_image.cbFastRender = new QCheckBox(i18n("Fast rendering"), vgbQual,
                                      "fastrender");
  m_image.cbFastRender->setChecked(properties->fastRender());

  m_image.cbDither16bit =
    new QCheckBox(i18n("Dither in HiColor (15/16bit) modes"), vgbQual,
                  "dither16bit");
  m_image.cbDither16bit->setChecked(properties->dither16bit());

  m_image.cbDither8bit =
    new QCheckBox(i18n("Dither in LowColor (<=8bit) modes"), vgbQual,
                  "dither8bit");
  m_image.cbDither8bit->setChecked(properties->dither8bit());

  m_image.cbOwnPalette =
    new QCheckBox( i18n("Use own color palette"), vgbQual, "pal");
  m_image.cbOwnPalette->setChecked(properties->ownPalette());
  connect(m_image.cbOwnPalette, SIGNAL(clicked()),
          this, SLOT(slotUseOwnPalette()));

  m_image.cbFastRemap =
    new QCheckBox(i18n("Fast palette remapping"), vgbQual, "remap");
  m_image.cbFastRemap->setChecked(properties->fastRemap());

  m_image.maxCacheSpinBox = new KIntNumInput(vgbQual, "editmaxcache");
  m_image.maxCacheSpinBox->setLabel(i18n("Maximum cache size (MB): "),
                                   AlignVCenter);
  m_image.maxCacheSpinBox->setRange(0, 500, 1);
  m_image.maxCacheSpinBox->setValue(properties->maxCache() / 1024);
  QToolTip::add(m_image.maxCacheSpinBox, i18n("0 = don't limit"));

  // Anpassen:
  QVGroupBox *vgbAdjust = new QVGroupBox(i18n("Adjustments"), tabContent2);

  m_image.sbBrightness =
    new KIntNumInput(vgbAdjust, "brightness spinbox");
  m_image.sbBrightness->setRange(-256, 256, 1, true);
  m_image.sbBrightness->setValue(properties->brightness());
  m_image.sbBrightness->setLabel(i18n("Brightness"), AlignVCenter);

  m_image.sbContrast =
    new KIntNumInput(m_image.sbBrightness, 0, vgbAdjust, 10,
                     "contrast spinbox");
  m_image.sbContrast->setRange(-256, 256, 1, true);
  m_image.sbContrast->setValue(properties->contrast());
  m_image.sbContrast->setLabel(i18n("Contrast"), AlignVCenter);

  m_image.sbGamma =
    new KIntNumInput(m_image.sbContrast, 0, vgbAdjust, 10,
                     "gamma spinbox");
  m_image.sbGamma->setRange(-256, 256, 1, true);
  m_image.sbGamma->setValue(properties->gamma());
  m_image.sbGamma->setLabel(i18n("Gamma"), AlignVCenter);

  QVBoxLayout *gbScaleLayout =
    new QVBoxLayout(gbScale, 10, 5, "scale layout");
  QHBoxLayout *scaleSubLayout = new QHBoxLayout( -1, "scale sublayout" );
  gbScaleLayout->addSpacing(6);
  gbScaleLayout->addWidget(m_image.cbDownScale, 0, AlignLeft );
  gbScaleLayout->addLayout(scaleSubLayout, 0);
  scaleSubLayout->addWidget(m_image.cbUpScale);
  scaleSubLayout->addWidget(m_image.sbMaxUpScaleFactor);

  // Preview:
  QGroupBox *gbPreview = new QGroupBox(i18n("Preview"), vgbAdjust);
  gbPreview->setAlignment(AlignCenter);

  QLabel *lbImOriginal = new QLabel(i18n("Original"), gbPreview);
  m_image.imOriginal = new ImageWindow(gbPreview, "original image");

  QLabel *lbImFiltered = new QLabel(i18n("Modified"), gbPreview);
  m_image.imFiltered =
    new ImageWindow(m_image.imOriginal->getImlibData(), gbPreview, "");
  connect(m_image.imFiltered, SIGNAL(destroyed()), SLOT(slotNoImage()));


  // Preview-Image:
  QString filename = locate("data", "ktourpresenter/preview.png");

  if ( !m_image.imOriginal->loadImage(filename, true) )
  {
    m_image.imOriginal = 0L;
  }
  else
  {
    QWhatsThis::add(m_image.imOriginal, i18n("The original preview image."));
    m_image.imOriginal->setFixedSize(m_image.imOriginal->size());
  } // END if

  if ( !m_image.imFiltered->loadImage(filename, true) )
  {
    m_image.imFiltered = 0L;
  }
  else
  {
    QWhatsThis::add(m_image.imFiltered, i18n("The filtered preview image."));
    m_image.imFiltered->setFixedSize(m_image.imFiltered->size());
  } // END if

  //  *** Layout ***
  QVBoxLayout *topLayoutGeneral =
    new QVBoxLayout(tabContent1, 0, spacingHint());
  QVBoxLayout *topLayoutModify =
    new QVBoxLayout(tabContent2, 0, spacingHint());

  QGridLayout *gPreviewLayout =
    new QGridLayout(gbPreview, 2, 2, 0, -1, "previewlayout");

  topLayoutGeneral->addWidget(gbScale);
  topLayoutGeneral->addWidget(vgbQual);
  topLayoutModify->addWidget(vgbAdjust);

  tabWidget->insertTab(tabContent1, i18n("General"));
  tabWidget->insertTab(tabContent2, i18n("Adjust"));

  topLayout->addWidget(tabWidget);

  if ( m_image.imFiltered )
  {
    gPreviewLayout->setMargin(10);
    gPreviewLayout->setSpacing(KDialog::spacingHint());
    gPreviewLayout->addWidget(lbImOriginal, 0, 0, AlignCenter);
    gPreviewLayout->addWidget(lbImFiltered, 0, 1, AlignCenter | AlignTop);
    gPreviewLayout->addWidget(m_image.imOriginal, 1, 0, AlignCenter);
    gPreviewLayout->addWidget(m_image.imFiltered, 1, 1,
                                                  AlignCenter | AlignTop);
  } // END if


  // *** Connects ***
  connect(m_image.sbBrightness, SIGNAL(valueChanged(int)),
                                SLOT(slotUpdatePreview()));
  connect(m_image.sbContrast,   SIGNAL(valueChanged(int)),
                                SLOT(slotUpdatePreview()));
  connect(m_image.sbGamma,      SIGNAL(valueChanged(int)),
                                SLOT(slotUpdatePreview()));

} // END setupImagePage()


#if KDE_VERSION < 290
void ConfigureDialog::setupKeysPage()
{
  QFrame *page =
    addPage(i18n("Keys"), i18n("Configuration of KTourPresenter Hot-Keys"),
            BarIcon("key_bindings", KIcon::SizeMedium));

  // *** Widgets ***
  m_keys.map = m_accel->keyDict();
  m_keys.chooser = new KKeyChooser(&m_keys.map, page, true);

  // *** Layout ***
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());
  topLayout->addWidget(m_keys.chooser);

} // END setupKeysPage()
#endif


void ConfigureDialog::setupToolbarPage()
{
  QFrame *page =
    addPage(i18n("Toolbar"), i18n("Configuration of the Toolbar"),
            BarIcon("wizard", KIcon::SizeMedium));

  // *** Widgets ***
  m_toolbar.edit = new KEditToolbarWidget(m_toplevel->factory(), page);

  // *** Connect ***
  connect(m_toolbar.edit, SIGNAL(enableOk(bool)),
          this,          SLOT(slotToolbarDirty(bool)));

  // *** Layout ***
  QVBoxLayout *topLayout = new QVBoxLayout(page, 0, spacingHint());
  topLayout->addWidget(m_toolbar.edit);

} // END setupToolbar()


void ConfigureDialog::slotOpenPlayFile()
{
  KURL url = KFileDialog::getOpenURL(properties->base(),
        i18n("*.ini|Play File (*.ini)\n"
             "*|All Files"), this,
        i18n("Select Presentation File..."));

  if ( url.isValid() )
  {
    QString file = url.path();
    int pos = file.findRev('/');

    if ( pos != -1 )
    {
      file = file.right( file.length() - pos -1);
    }

    properties->playFilename(file);
    m_general.playFileLE->setText(file);
  } // END if isValid()

} // END slotOpenPlayFile()


void ConfigureDialog::slotOpenDefaultImg()
{
  KURL url = KFileDialog::getOpenURL(properties->base(),
        i18n("*.jpg *.png *.gif|Image Files (*.jpg *.png *.gif)\n"
             "*|All Files"), this,
        i18n("Select Default Image..."));

  if ( url.isValid() )
  {
    QString file = url.path();
    int pos = file.findRev('/');

    if ( pos != -1 )
    {
      file = file.right( file.length() - pos -1);
    }

    properties->defaultImageFilename(file);
    m_general.defaultImgFileLE->setText(file);
  } // END if isValid()

} // END slotOpenDefaultImg()


void ConfigureDialog::slotOpenReportFile()
{
  KURL url = KFileDialog::getOpenURL(properties->base(),
    i18n("*.html *.htm *.HTML *.HTM|HTML File (*.html *.htm *.HTML *.HTM)\n"
         "*|All Files"), this,
    i18n("Select Report File..."));

  if ( url.isValid() )
  {
    QString file = url.path();
    int pos = file.findRev('/');

    if ( pos != -1 )
    {
      file = file.right( file.length() - pos -1);
    }

    properties->reportFilename(file);
    m_general.reportFileLE->setText(file);
  } // END if isValid()

} // END slotOpenReportFile()


void ConfigureDialog::slotOpenBrowser()
{
  KURL url = KFileDialog::getOpenURL(0, 0, this, i18n("Select Browser..."));

  if ( url.isValid() )
  {
    properties->browserName(url.path());
    m_general.browserNameLE->setText(url.path());
  } // END if isValid()

} // END slotOpenBrowser()


void ConfigureDialog::slotOpenBasePath()
{
  KURL url=KFileDialog::getExistingDirectory(m_general.basePathLE->text(),
                            this, i18n("Select base directory..."));

  if ( url.isValid() )
  {
    properties->base(url.path());
    m_general.basePathLE->setText(url.path());
  } // END if isValid()

} // END slotOpenBasePath()


void ConfigureDialog::slotOk()
{
  slotApply();
  accept();
} // END slotOK()


void ConfigureDialog::slotApply()
{
  // General:
  properties->base(m_general.basePathLE->text());
  properties->defaultImageFilename(m_general.defaultImgFileLE->text());
  properties->reportFilename(m_general.reportFileLE->text());
  properties->browserName(m_general.browserNameLE->text());

  // Presentation:
  properties->autoLoad(m_presentation.autoLoadCB->isChecked());
  properties->autoStart(m_presentation.autoStartCB->isChecked());
  properties->autoQuit(m_presentation.autoQuitCB->isChecked());
  properties->fullscreen(m_presentation.fullscreenCB->isChecked());
#if KDE_VERSION >= 220
  bool ssaverValue = m_presentation.disableSSaverCB->isChecked();
  if ( ssaverValue != properties->disableScreensaver() )
  {
    properties->disableScreensaver(ssaverValue);
    emit sigDisableScreensaver(ssaverValue);
  } // END if
#endif
  QColor newColor = m_presentation.backgroundButton->color();
  if ( properties->backgroundColor() != newColor )
  {
    properties->backgroundColor(newColor);
    emit sigBackgroundColorChanged(newColor);
  } // END if
  // *** FIXME: vvv im Moment nicht vorhanden !!! vvv
  //properties->hideMouse(m_presentation.hideMouseCB->isChecked());

  // Imlib:
  properties->downScale(m_image.cbDownScale->isChecked());
  properties->upScale(m_image.cbUpScale->isChecked());
  properties->maxUpScale(m_image.sbMaxUpScaleFactor->value());
  properties->fastRender(m_image.cbFastRender->isChecked());
  properties->dither16bit(m_image.cbDither16bit->isChecked());
  properties->dither8bit(m_image.cbDither8bit->isChecked());
  properties->ownPalette(m_image.cbOwnPalette->isChecked());
  properties->fastRemap(m_image.cbFastRemap->isChecked());
  properties->maxCache(m_image.maxCacheSpinBox->value() * 1024);
  int brightness = m_image.sbBrightness->value();
  int contrast   = m_image.sbContrast->value();
  int gamma      = m_image.sbGamma->value();
  if ( m_oldBrightness != brightness ||
       m_oldContrast   != contrast   ||
       m_oldGamma      != gamma         )
  {
    properties->brightness(brightness);
    properties->contrast(contrast);
    properties->gamma(gamma);

    emit sigModifierChanged();
  } // END if

#if KDE_VERSION < 290
  // Keys:
  m_accel->setKeyDict(m_keys.map);
#endif

  // Toolbar:
  if ( m_toolbarDirty )
  {
    m_toolbar.edit->save();
    emit sigToolbarChanged();
  } // END if

} // END slotApply()


void ConfigureDialog::slotDefault()
{
  // setze Werte zurueck:
  properties->defaultValues();

  // Passe dementsprechend die Dialog-Elemente an:
  setValues();
} // END slotDefault()


void ConfigureDialog::slotEnableMaxScale(bool flag)
{
  m_image.sbMaxUpScaleFactor->setEnabled(flag);
} // END slotEnableMaxScale()


void ConfigureDialog::slotUpdatePreview()
{
  if ( !m_image.imFiltered )
    return;

  m_image.imFiltered->setAutoRender(false);
  m_image.imFiltered->setBrightness(m_image.sbBrightness->value());
  m_image.imFiltered->setContrast(  m_image.sbContrast->value());
  m_image.imFiltered->setGamma(     m_image.sbGamma->value());
  m_image.imFiltered->updateImage();
  m_image.imFiltered->setAutoRender(true);

} // END slotUpdatePreview()


void ConfigureDialog::slotNoImage()
{
  m_image.imFiltered = 0L;
} // END slotNoImage()


void ConfigureDialog::slotUseOwnPalette()
{
  m_image.cbFastRemap->setEnabled(m_image.cbOwnPalette->isChecked());
} // END slotUseOwnPalette()


void ConfigureDialog::slotToolbarDirty(bool flag)
{
  if ( flag )
    m_toolbarDirty = true;

} // END slotToolbarDirty()
